/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.collections.set;

import de.alpharogroup.collections.CollectionExtensions;
import de.alpharogroup.collections.set.InsertionOrderSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public final class SetFactory {
    @SafeVarargs
    public static final <T> Set<T> newHashSet(T ... elements) {
        return SetFactory.newHashSet(null, elements);
    }

    @SafeVarargs
    public static final <T> Set<T> newHashSet(Collection<T> collection, T ... elements) {
        HashSet<Object> set = CollectionExtensions.isNotEmpty(collection) ? new HashSet<T>(collection) : new HashSet();
        if (0 < elements.length) {
            Collections.addAll(set, elements);
        }
        return set;
    }

    public static final <T> Set<T> newHashSet(int initialCapacity) {
        return new HashSet(initialCapacity);
    }

    @SafeVarargs
    public static final <T> Set<T> newLinkedHashSet(T ... elements) {
        return SetFactory.newLinkedHashSet(null, elements);
    }

    public static final <T> Set<T> newLinkedHashSet(int initialCapacity) {
        return new LinkedHashSet(initialCapacity);
    }

    @SafeVarargs
    public static final <T> Set<T> newLinkedHashSet(Collection<T> collection, T ... elements) {
        LinkedHashSet<Object> set = CollectionExtensions.isNotEmpty(collection) ? new LinkedHashSet<T>(collection) : new LinkedHashSet();
        if (0 < elements.length) {
            Collections.addAll(set, elements);
        }
        return set;
    }

    @SafeVarargs
    public static final <T> Set<T> newInsertionOrderSet(T ... elements) {
        return SetFactory.newInsertionOrderSet(null, elements);
    }

    public static final <T> Set<T> newInsertionOrderSet(int initialCapacity) {
        return new InsertionOrderSet(initialCapacity);
    }

    @SafeVarargs
    public static final <T> Set<T> newInsertionOrderSet(Collection<T> collection, T ... elements) {
        InsertionOrderSet<Object> set = CollectionExtensions.isNotEmpty(collection) ? new InsertionOrderSet<T>(collection) : new InsertionOrderSet();
        if (0 < elements.length) {
            Collections.addAll(set, elements);
        }
        return set;
    }

    @SafeVarargs
    public static final <T> SortedSet<T> newTreeSet(T ... elements) {
        return SetFactory.newTreeSet(null, elements);
    }

    @SafeVarargs
    public static final <T> SortedSet<T> newTreeSet(Collection<T> collection, T ... elements) {
        return SetFactory.newTreeSet(collection, null, elements);
    }

    @SafeVarargs
    public static final <T> SortedSet<T> newTreeSet(Collection<T> collection, Comparator<T> comparator, T ... elements) {
        TreeSet<Object> sortedSet = comparator != null ? new TreeSet<T>(comparator) : new TreeSet();
        if (CollectionExtensions.isNotEmpty(collection)) {
            sortedSet.addAll(collection);
        }
        if (0 < elements.length) {
            Collections.addAll(sortedSet, elements);
        }
        return sortedSet;
    }

    private SetFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

