/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.collections.list;

import de.alpharogroup.collections.CollectionExtensions;
import de.alpharogroup.collections.array.ArrayFactory;
import de.alpharogroup.collections.modifications.ModifiedCollections;
import de.alpharogroup.comparators.SortOrderComparator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections4.ComparatorUtils;

public final class ListExtensions {
    public static <T> boolean containAtleastOneObject(List<T> toSearch, List<T> search) {
        boolean contains = false;
        int size = toSearch.size();
        for (int i = 0; i < size && !(contains = search.contains(toSearch.get(i))); ++i) {
        }
        return contains;
    }

    public static <T> T getFirst(List<T> list) {
        if (CollectionExtensions.isNotEmpty(list)) {
            return list.get(0);
        }
        return null;
    }

    public static <T> T getLast(List<T> list) {
        if (CollectionExtensions.isNotEmpty(list)) {
            return list.get(list.size() - 1);
        }
        return null;
    }

    public static <T> ModifiedCollections<T> getModifiedCollections(Collection<T> previous, Collection<T> next) {
        return new ModifiedCollections<T>().getModifiedLists(previous, next);
    }

    public static <T> List<T> getSameElementsFromLists(List<T> toSearch, List<T> search) {
        ArrayList<T> foundElements = null;
        int size = toSearch.size();
        for (int i = 0; i < size; ++i) {
            T element = toSearch.get(i);
            if (!search.contains(element)) continue;
            if (foundElements == null) {
                foundElements = new ArrayList<T>();
            }
            foundElements.add(element);
        }
        return foundElements;
    }

    public static <T> boolean isEqualListOfArrays(List<T[]> one, List<T[]> other) {
        if (one == null && other == null) {
            return true;
        }
        if (one == null && other != null || one != null && other == null || one.size() != other.size()) {
            return false;
        }
        for (int i = 0; i < one.size(); ++i) {
            if (Arrays.deepEquals(one.get(i), other.get(i))) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean isFirst(List<T> list, T element) {
        int indexOfElement = list.indexOf(element);
        return indexOfElement == 0;
    }

    public static <T> boolean isLast(List<T> list, T element) {
        T last = ListExtensions.getLast(list);
        if (last != null) {
            return last.equals(element);
        }
        return false;
    }

    public static <T> void printCollection(Collection<T> collection) {
        int count = 1;
        for (T element : collection) {
            System.err.println(count + ".)element:" + element);
            ++count;
        }
    }

    public static <T> T removeFirst(List<T> list) {
        if (!CollectionExtensions.isEmpty(list) && 0 < list.size()) {
            return list.remove(0);
        }
        return null;
    }

    public static <T> T removeLast(List<T> list) {
        if (!CollectionExtensions.isEmpty(list) && 0 < list.size()) {
            return list.remove(list.size() - 1);
        }
        return null;
    }

    public static <T> List<T> removeLastValues(List<T> v, int remove) {
        if (remove < v.size()) {
            List<T> l = v.subList(remove, v.size());
            return l;
        }
        throw new IllegalArgumentException("You cannot remove more element than in the ArrayList exists. \nSize from ArrayList:" + v.size() + "\nElements to be removed:" + remove + "\n The same ArrayList will be returned.");
    }

    public static <T> List<T> revertOrder(List<T> listToRevert) {
        ArrayList<T> revertedList = new ArrayList<T>();
        int size = listToRevert.size();
        while (0 < size) {
            revertedList.add(listToRevert.get(--size));
        }
        return revertedList;
    }

    public static <T> void shuffle(List<T> source, List<T> destination, int[] selectedElements) {
        int lastIndex;
        for (int i = lastIndex = selectedElements.length - 1; -1 < i; --i) {
            int selectedRow = selectedElements[i];
            T row = source.remove(selectedRow);
            destination.add(row);
        }
    }

    public static <T> void sortByProperty(List<T> list, String property, boolean ascending) {
        Object comparator = new BeanComparator(property, SortOrderComparator.of());
        if (ascending) {
            comparator = ComparatorUtils.reversedComparator((Comparator)comparator);
        }
        Collections.sort(list, comparator);
    }

    public static <T> List<List<T>> splitToParts(Collection<T> collection, int times) {
        ArrayList<List<T>> returnList = new ArrayList<List<T>>();
        ArrayList<T> tmp = new ArrayList<T>();
        Iterator<T> it = collection.iterator();
        int count = 0;
        while (it.hasNext()) {
            if (count == times) {
                returnList.add(tmp);
                tmp = new ArrayList();
                tmp.add(it.next());
                count = 1;
                continue;
            }
            tmp.add(it.next());
            ++count;
        }
        if (!tmp.isEmpty()) {
            returnList.add(tmp);
        }
        return returnList;
    }

    @SafeVarargs
    public static <T> T[] toArray(T ... elements) {
        T[] decorator = ArrayFactory.newArray(elements);
        return decorator;
    }

    public static <T> List<T> toList(Enumeration<T> enumaration) {
        ArrayList<T> list = new ArrayList<T>();
        while (enumaration.hasMoreElements()) {
            list.add(enumaration.nextElement());
        }
        return list;
    }

    public static <T> List<T> toList(Set<T> set) {
        return new ArrayList<T>(set);
    }

    @SafeVarargs
    public static <T> Object[] toObjectArray(T ... elements) {
        Object[] decorator = new Object[elements.length];
        System.arraycopy(elements, 0, decorator, 0, elements.length);
        return decorator;
    }

    private ListExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

