/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.collections.array;

public final class ArrayFactory {
    @SafeVarargs
    public static <T> T[] newArray(T ... elements) {
        return elements;
    }

    public static Integer[] newRangeArray(int start, int end) {
        if (end < start) {
            throw new IllegalArgumentException("Parameter end should be greater than parameter start.");
        }
        int length = end - start + 1;
        Integer[] array = new Integer[length];
        for (int i = start; i <= end; ++i) {
            array[i - start] = i;
        }
        return array;
    }

    @SafeVarargs
    public static boolean[] newBooleanArray(boolean ... elements) {
        return elements;
    }

    @SafeVarargs
    public static byte[] newByteArray(byte ... elements) {
        return elements;
    }

    @SafeVarargs
    public static char[] newCharArray(char ... elements) {
        return elements;
    }

    @SafeVarargs
    public static int[] newIntArray(int ... elements) {
        return elements;
    }

    @SafeVarargs
    public static long[] newLongArray(long ... elements) {
        return elements;
    }

    @SafeVarargs
    public static float[] newFloatArray(float ... elements) {
        return elements;
    }

    @SafeVarargs
    public static double[] newDoubleArray(double ... elements) {
        return elements;
    }

    @SafeVarargs
    public static short[] newShortArray(short ... elements) {
        return elements;
    }

    private ArrayFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

