/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.collections.map;

import de.alpharogroup.collections.map.InsertionOrderMap;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.Factory;
import org.apache.commons.collections4.functors.InstantiateFactory;
import org.apache.commons.collections4.map.LazyMap;

public final class MapFactory {
    public static <K, V> Map<K, V> newInsertionOrderMap() {
        return new InsertionOrderMap();
    }

    public static Map<Integer, Map<String, String>> newAssosiativeArrayMap() {
        return MapFactory.newLazyMap();
    }

    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap() {
        return new ConcurrentHashMap();
    }

    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap(int initialCapacity) {
        return new ConcurrentHashMap(initialCapacity);
    }

    public static <K, V> Map<K, V> newHashMap() {
        return new HashMap();
    }

    public static <K, V> Map<K, V> newLinkedHashMap() {
        return new LinkedHashMap();
    }

    public static <K, V> Map<K, V> newLinkedHashMap(int initialCapacity) {
        return new LinkedHashMap(initialCapacity);
    }

    public static <K, V> Map<K, V> newHashMap(int initialCapacity) {
        return new HashMap(initialCapacity);
    }

    public static <K, V> Map<K, V> newLazyMap() {
        return LazyMap.lazyMap(new HashMap(), (Factory)new InstantiateFactory(HashMap.class));
    }

    public static <K, V> Map<K, V> newLazyTreeMap() {
        return LazyMap.lazyMap(new TreeMap(), (Factory)new InstantiateFactory(TreeMap.class));
    }

    public static <K, V> Map<K, V> newLazyTreeMap(Comparator<? super K> comparator) {
        return LazyMap.lazyMap(new TreeMap(comparator), (Factory)new InstantiateFactory(TreeMap.class));
    }

    public static <K, V> Map<K, V> newTreeMap() {
        return new TreeMap();
    }

    public static <K, V> Map<K, V> newTreeMap(Comparator<? super K> comparator) {
        return new TreeMap(comparator);
    }

    private MapFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

