/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.collections.list;

import de.alpharogroup.collections.CollectionExtensions;
import de.alpharogroup.collections.array.ArrayFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class ListFactory {
    @SafeVarargs
    public static <T> List<T> newArrayList(Collection<T> collection, T ... elements) {
        ArrayList<Object> list;
        if (CollectionExtensions.isNotEmpty(collection)) {
            list = new ArrayList<T>(collection);
            Collections.addAll(list, elements);
        } else {
            list = new ArrayList();
            Collections.addAll(list, elements);
        }
        return list;
    }

    public static <T> List<T> newArrayList(int initialCapacity) {
        return new ArrayList(initialCapacity);
    }

    @SafeVarargs
    public static <T> List<T> newArrayList(T ... elements) {
        return ListFactory.newArrayList(null, elements);
    }

    public static List<Integer> newRangeList(int start, int end) {
        return Arrays.asList(ArrayFactory.newRangeArray(start, end));
    }

    private ListFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

