/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.collections;

import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.collections4.CollectionUtils;

public final class CollectionExtensions {
    public static <T> boolean isEqualCollection(Collection<T> one, Collection<T> other) {
        if (one == null && other == null) {
            return true;
        }
        if (one == null && other != null || one != null && other == null || one.size() != other.size()) {
            return false;
        }
        return CollectionUtils.retainAll(one, other).isEmpty();
    }

    public static <T> void difference(Collection<T> collection1, Collection<T> collection2) {
        collection1.removeAll(collection2);
    }

    @SafeVarargs
    public static <T> Collection<T> intersection(Collection<T> ... toIntersect) {
        if (1 < toIntersect.length) {
            Collection<T> first = toIntersect[0];
            for (int i = 1; i < toIntersect.length; ++i) {
                first.retainAll(toIntersect[i]);
            }
            return first;
        }
        return null;
    }

    public static <T> boolean isNotEmpty(Collection<T> collection) {
        return collection != null && !collection.isEmpty();
    }

    public static <T> boolean isEmpty(Collection<T> collection) {
        return collection == null || collection.isEmpty();
    }

    public static <T> int hashCode(Collection<T[]> arrayObjects) {
        int hashCode = 1;
        for (Object[] objectArray : arrayObjects) {
            hashCode = 31 * hashCode * Arrays.hashCode(objectArray);
        }
        return hashCode;
    }

    private CollectionExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

