/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.collections.properties;

import de.alpharogroup.collections.CollectionExtensions;
import de.alpharogroup.collections.list.ListExtensions;
import de.alpharogroup.collections.properties.SortedProperties;
import de.alpharogroup.comparators.NullCheckComparator;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class IndexSortedProperties
extends SortedProperties {
    private static final long serialVersionUID = 1L;
    private List<Object> keys;

    public static IndexSortedProperties of() {
        return new IndexSortedProperties();
    }

    public static IndexSortedProperties of(Properties defaults) {
        return new IndexSortedProperties(defaults);
    }

    public static IndexSortedProperties of(Properties defaults, final Comparator<Object> comparator) {
        return new IndexSortedProperties(defaults){
            private static final long serialVersionUID = 1L;

            @Override
            protected Comparator<Object> newComparator() {
                return NullCheckComparator.of((Comparator)comparator, (boolean)false);
            }
        };
    }

    public static IndexSortedProperties of(Properties defaults, final Comparator<Object> comparator, final boolean nullIsGreaterThan) {
        return new IndexSortedProperties(defaults){
            private static final long serialVersionUID = 1L;

            @Override
            protected Comparator<Object> newComparator() {
                return NullCheckComparator.of((Comparator)comparator, (boolean)nullIsGreaterThan);
            }
        };
    }

    public IndexSortedProperties() {
        this(new Properties());
    }

    public IndexSortedProperties(Properties defaults) {
        super(defaults);
        this.sortKeyList(defaults.keySet());
    }

    private void addKey(Object key) {
        this.keys.add(key);
        this.resortKeyList();
    }

    @Override
    public synchronized void clear() {
        if (CollectionExtensions.isNotEmpty(this.keys)) {
            this.keys.clear();
        }
        super.clear();
    }

    public synchronized Object get(int index) {
        if (index < this.keys.size()) {
            return this.getProperty((String)this.keys.get(index));
        }
        return null;
    }

    public String getProperty(int index) {
        if (index < this.keys.size()) {
            return this.getProperty((String)this.keys.get(index));
        }
        return null;
    }

    public synchronized int indexOf(Object object) {
        for (Object key : this.keys) {
            String value = this.getProperty((String)key);
            if (!object.equals(value)) continue;
            return this.keys.indexOf(key);
        }
        return -1;
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        this.addKey(key);
        return super.put(key, value);
    }

    @Override
    public synchronized void putAll(Map<? extends Object, ? extends Object> t) {
        super.putAll(t);
        this.sortKeyList(this.keySet());
    }

    public synchronized Object remove(int index) {
        if (index < this.keys.size()) {
            return this.remove(this.keys.get(index));
        }
        return null;
    }

    @Override
    public synchronized Object remove(Object key) {
        this.removeKey(key);
        return super.remove(key);
    }

    @Override
    public synchronized boolean remove(Object key, Object value) {
        boolean removed = super.remove(key, value);
        if (removed) {
            this.removeKey(key);
        }
        return removed;
    }

    private void removeKey(Object key) {
        this.keys.remove(key);
        this.resortKeyList();
    }

    private void resortKeyList() {
        Collections.sort(this.keys, this.getComparator());
    }

    private void sortKeyList(Set<Object> keySet) {
        this.keys = ListExtensions.newArrayList(keySet, new Object[0]);
        this.resortKeyList();
    }
}

