/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.collections.pairs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public final class KeySetPair<K, V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private K key;
    private Set<V> values;

    public static <K, V> KeySetPairBuilder<K, V> builder() {
        return new KeySetPairBuilder();
    }

    public KeySetPairBuilder<K, V> toBuilder() {
        return new KeySetPairBuilder().key(this.key).values(this.values);
    }

    public K getKey() {
        return this.key;
    }

    public Set<V> getValues() {
        return this.values;
    }

    public void setKey(K key) {
        this.key = key;
    }

    public void setValues(Set<V> values) {
        this.values = values;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeySetPair)) {
            return false;
        }
        KeySetPair other = (KeySetPair)o;
        K this$key = this.getKey();
        K other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        Set<V> this$values = this.getValues();
        Set<V> other$values = other.getValues();
        return !(this$values == null ? other$values != null : !((Object)this$values).equals(other$values));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        K $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        Set<V> $values = this.getValues();
        result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
        return result;
    }

    public String toString() {
        return "KeySetPair(key=" + this.getKey() + ", values=" + this.getValues() + ")";
    }

    public KeySetPair() {
    }

    public KeySetPair(K key, Set<V> values) {
        this.key = key;
        this.values = values;
    }

    public static class KeySetPairBuilder<K, V> {
        private K key;
        private ArrayList<V> values;

        KeySetPairBuilder() {
        }

        public KeySetPairBuilder<K, V> key(K key) {
            this.key = key;
            return this;
        }

        public KeySetPairBuilder<K, V> value(V value) {
            if (this.values == null) {
                this.values = new ArrayList();
            }
            this.values.add(value);
            return this;
        }

        public KeySetPairBuilder<K, V> values(Collection<? extends V> values) {
            if (this.values == null) {
                this.values = new ArrayList();
            }
            this.values.addAll(values);
            return this;
        }

        public KeySetPairBuilder<K, V> clearValues() {
            if (this.values != null) {
                this.values.clear();
            }
            return this;
        }

        public KeySetPair<K, V> build() {
            Set<Object> values;
            switch (this.values == null ? 0 : this.values.size()) {
                case 0: {
                    values = Collections.emptySet();
                    break;
                }
                case 1: {
                    values = Collections.singleton(this.values.get(0));
                    break;
                }
                default: {
                    values = new LinkedHashSet(this.values.size() < 0x40000000 ? 1 + this.values.size() + (this.values.size() - 3) / 3 : Integer.MAX_VALUE);
                    values.addAll(this.values);
                    values = Collections.unmodifiableSet(values);
                }
            }
            return new KeySetPair(this.key, values);
        }

        public String toString() {
            return "KeySetPair.KeySetPairBuilder(key=" + this.key + ", values=" + this.values + ")";
        }
    }
}

