/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.collections.set;

import de.alpharogroup.collections.CollectionExtensions;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public final class SetExtensions {
    @SafeVarargs
    public static final <T> Set<T> newHashSet(T ... elements) {
        return SetExtensions.newHashSet(null, elements);
    }

    @SafeVarargs
    public static final <T> Set<T> newHashSet(Collection<T> collection, T ... elements) {
        HashSet<Object> set = CollectionExtensions.isNotEmpty(collection) ? new HashSet<T>(collection) : new HashSet();
        if (0 < elements.length) {
            Collections.addAll(set, elements);
        }
        return set;
    }

    @SafeVarargs
    public static final <T> SortedSet<T> newTreeSet(T ... elements) {
        return SetExtensions.newTreeSet(null, elements);
    }

    @SafeVarargs
    public static final <T> SortedSet<T> newTreeSet(Collection<T> collection, T ... elements) {
        return SetExtensions.newTreeSet(collection, null, elements);
    }

    @SafeVarargs
    public static final <T> SortedSet<T> newTreeSet(Collection<T> collection, Comparator<T> comparator, T ... elements) {
        TreeSet<Object> sortedSet = comparator != null ? new TreeSet<T>(comparator) : new TreeSet();
        if (CollectionExtensions.isNotEmpty(collection)) {
            sortedSet.addAll(collection);
        }
        if (0 < elements.length) {
            Collections.addAll(sortedSet, elements);
        }
        return sortedSet;
    }

    @Deprecated
    public static <T> boolean isEmpty(Set<T> set) {
        return CollectionExtensions.isEmpty(set);
    }

    @Deprecated
    public static <T> boolean isNotEmpty(Set<T> set) {
        return CollectionExtensions.isNotEmpty(set);
    }

    public static <T> Set<T> toSet(Collection<T> collection) {
        return SetExtensions.newHashSet(collection, new Object[0]);
    }

    public static <T> SortedSet<T> toSortedSet(Collection<T> collection) {
        return SetExtensions.newTreeSet(collection, new Object[0]);
    }

    private SetExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

