/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.collections.map;

import de.alpharogroup.collections.map.InsertionOrderMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.Factory;
import org.apache.commons.collections4.functors.InstantiateFactory;
import org.apache.commons.collections4.map.LazyMap;

public final class MapExtensions {
    public static <K, V> Map<K, V> newInsertionOrderMap() {
        return new InsertionOrderMap();
    }

    public static <K, V> K getKeyFromValue(Map<K, V> map, V value) {
        Map.Entry<K, V> entry;
        K key = null;
        Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
        while (iterator.hasNext() && !map.get(key = (K)(entry = iterator.next()).getKey()).equals(value)) {
        }
        return key;
    }

    public static <K, V> Collection<K> getKeysFromValue(Map<K, V> map, V value) {
        ArrayList<K> keys = new ArrayList<K>();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            V val = entry.getValue();
            if (!val.equals(value)) continue;
            K key = entry.getKey();
            keys.add(key);
        }
        return keys;
    }

    public static Map<Integer, Map<String, String>> newAssosiativeArrayMap() {
        return MapExtensions.newLazyMap();
    }

    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap() {
        return new ConcurrentHashMap();
    }

    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap(int initialCapacity) {
        return new ConcurrentHashMap(initialCapacity);
    }

    public static <K, V> Map<K, V> newHashMap() {
        return new HashMap();
    }

    public static <K, V> Map<K, V> newLinkedHashMap() {
        return new LinkedHashMap();
    }

    public static <K, V> Map<K, V> newLinkedHashMap(int initialCapacity) {
        return new LinkedHashMap(initialCapacity);
    }

    public static <K, V> Map<K, V> newHashMap(int initialCapacity) {
        return new HashMap(initialCapacity);
    }

    public static <K, V> Map<K, V> newLazyMap() {
        return LazyMap.lazyMap(new HashMap(), (Factory)new InstantiateFactory(HashMap.class));
    }

    public static <K, V> Map<K, V> newLazyTreeMap() {
        return LazyMap.lazyMap(new TreeMap(), (Factory)new InstantiateFactory(TreeMap.class));
    }

    public static <K, V> Map<K, V> newLazyTreeMap(Comparator<? super K> comparator) {
        return LazyMap.lazyMap(new TreeMap(comparator), (Factory)new InstantiateFactory(TreeMap.class));
    }

    public static <K, V> Map<K, V> newTreeMap() {
        return new TreeMap();
    }

    public static <K, V> Map<K, V> newTreeMap(Comparator<? super K> comparator) {
        return new TreeMap(comparator);
    }

    public static <T> Map<T, T> toGenericMap(T[][] twoDimArray) {
        LinkedHashMap<T, T> map = new LinkedHashMap<T, T>();
        for (T[] element : twoDimArray) {
            T key = element[0];
            T value = element[1];
            map.put(key, value);
        }
        return map;
    }

    public static Map<String, String> toMap(String[][] twoDimArray) {
        return MapExtensions.toGenericMap(twoDimArray);
    }

    private MapExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

