/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.collections.set;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class SetExtensions {
    @SafeVarargs
    public static final <T> Set<T> newHashSet(T ... elements) {
        return SetExtensions.newHashSet(null, elements);
    }

    @SafeVarargs
    public static final <T> Set<T> newHashSet(Collection<T> collection, T ... elements) {
        HashSet<Object> set = collection != null && !collection.isEmpty() ? new HashSet<T>(collection) : new HashSet();
        if (0 < elements.length) {
            Collections.addAll(set, elements);
        }
        return set;
    }

    public static <T> boolean isEmpty(Set<T> set) {
        return set == null || set.isEmpty();
    }

    public static <T> boolean isNotEmpty(Set<T> set) {
        return set != null && !set.isEmpty();
    }

    public static <T> Set<T> toSet(Collection<T> collection) {
        return SetExtensions.newHashSet(collection, new Object[0]);
    }

    private SetExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

