/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.collections.array;

import java.util.Arrays;
import java.util.List;

public final class ArrayExtensions {
    public static <T> List<T> asList(T[] array) {
        return ArrayExtensions.toList(array);
    }

    public static <T> T getFirst(T[] array) {
        if (array != null && array.length != 0) {
            return array[0];
        }
        return null;
    }

    public static <T> int getIndex(T[] array, T element) {
        return ArrayExtensions.indexOf(array, element);
    }

    public static <T> T getLast(T[] array) {
        if (array != null && array.length != 0) {
            int lastIndex = array.length - 1;
            return array[lastIndex];
        }
        return null;
    }

    public static <T> int getNextIndex(T[] array, T element) {
        int lastIndex = array.length - 1;
        int indexOfElement = ArrayExtensions.indexOf(array, element);
        if (indexOfElement == -1) {
            return indexOfElement;
        }
        if (indexOfElement == lastIndex) {
            return 0;
        }
        int nextIndex = indexOfElement + 1;
        return nextIndex;
    }

    public static <T> int[] getNextIndexes(T[] array, T element, int count) {
        if (element != null) {
            int[] nextIndexes = new int[count];
            T currentElement = element;
            for (int i = 0; i < count; ++i) {
                int nextIndex = ArrayExtensions.getNextIndex(array, currentElement);
                if (nextIndex == -1) {
                    return null;
                }
                nextIndexes[i] = nextIndex;
                currentElement = array[nextIndex];
            }
            return nextIndexes;
        }
        return null;
    }

    public static <T> int getPreviousIndex(T[] array, T element) {
        int lastIndex = array.length - 1;
        int indexOfElement = ArrayExtensions.indexOf(array, element);
        if (indexOfElement == -1) {
            return indexOfElement;
        }
        if (indexOfElement == 0) {
            return lastIndex;
        }
        int previousIndex = indexOfElement - 1;
        return previousIndex;
    }

    public static <T> int[] getPreviousIndexes(T[] array, T element, int count) {
        if (element != null) {
            int[] previousIndexes = new int[count];
            T currentElement = element;
            for (int i = 0; i < count; ++i) {
                int previousIndex = ArrayExtensions.getPreviousIndex(array, currentElement);
                if (previousIndex == -1) {
                    return null;
                }
                previousIndexes[i] = previousIndex;
                currentElement = array[previousIndex];
            }
            return previousIndexes;
        }
        return null;
    }

    public static <T> int indexOf(T[] array, T element) {
        int indexOfElement = Arrays.asList(array).indexOf(element);
        return indexOfElement;
    }

    public static <T> boolean isFirst(T[] array, T element) {
        int indexOfElement = Arrays.asList(array).indexOf(element);
        return indexOfElement == 0;
    }

    public static <T> boolean isLast(T[] array, T element) {
        int lastIndex = array.length - 1;
        int indexOfElement = Arrays.asList(array).indexOf(element);
        return indexOfElement == lastIndex;
    }

    @SafeVarargs
    public static <T> T[] newArray(T ... elements) {
        return elements;
    }

    public static byte[][] splitInChunks(byte[] bytes, int chunkSize) {
        int count;
        int size = (bytes.length - 1) / chunkSize + 1;
        byte[][] dataChunks = new byte[size][];
        int to = bytes.length;
        int from = count * chunkSize;
        for (count = size - 1; -1 < count; --count) {
            dataChunks[count] = Arrays.copyOfRange(bytes, from, to);
            to = from;
            from = to - chunkSize;
        }
        return dataChunks;
    }

    public static <T> List<T> toList(T[] array) {
        return Arrays.asList(array);
    }

    private ArrayExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

