/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.collections.properties;

import de.alpharogroup.collections.pairs.KeyValuePair;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PropertiesExtensions {
    public static final String SEARCH_FILE_PATTERN = "([^\\s]+(\\.(?i)(java|html|htm))$)";
    public static final String[] PROPERTIES_DELIMITERS = new String[]{"=", ":", " "};

    public static Map<String, List<String>> findRedundantValues(Properties properties) {
        List keys;
        LinkedHashMap reverseEntries = new LinkedHashMap();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!reverseEntries.containsKey(value)) {
                keys = new ArrayList<String>();
                keys.add(key);
                reverseEntries.put(value, keys);
                continue;
            }
            keys = (List)reverseEntries.get(value);
            keys.add(key);
        }
        LinkedHashMap<String, List<String>> redundantValues = new LinkedHashMap<String, List<String>>();
        for (Map.Entry entry : reverseEntries.entrySet()) {
            String key = (String)entry.getKey();
            keys = (List)entry.getValue();
            if (1 >= keys.size()) continue;
            redundantValues.put(key, keys);
        }
        return redundantValues;
    }

    public static Map<String, List<String>> getMatchedPrefixLists(Properties enProperties) {
        Enumeration<?> e = enProperties.propertyNames();
        LinkedHashMap<String, List<String>> matchedPrefixes = new LinkedHashMap<String, List<String>>();
        while (e.hasMoreElements()) {
            List<String> fullKeys;
            String key = (String)e.nextElement();
            int lastIndex = key.lastIndexOf(".");
            String subKey = null;
            subKey = 0 < lastIndex ? key.substring(0, lastIndex) : key;
            if (matchedPrefixes.containsKey(subKey)) {
                fullKeys = (List)matchedPrefixes.get(subKey);
                fullKeys.add(key);
                continue;
            }
            fullKeys = new ArrayList();
            fullKeys.add(key);
            matchedPrefixes.put(subKey, fullKeys);
        }
        return matchedPrefixes;
    }

    public static List<String> getPropertyParameters(String propertyValue) {
        ArrayList<String> parameterList = new ArrayList<String>();
        Pattern pattern = Pattern.compile("\\{.*?\\}");
        Matcher matcher = pattern.matcher(propertyValue);
        while (matcher.find()) {
            String parameter = matcher.group();
            String at = parameter.substring(1, parameter.length() - 1);
            parameterList.add(at);
        }
        return parameterList;
    }

    public static Properties loadProperties(File propertiesFile) throws IOException {
        Properties properties = null;
        InputStream is = null;
        if (propertiesFile.exists()) {
            is = propertiesFile.toURI().toURL().openStream();
            if (is != null) {
                properties = new Properties();
                properties.load(is);
            }
        } else {
            throw new FileNotFoundException(propertiesFile.getName() + " not found.");
        }
        return properties;
    }

    public static List<KeyValuePair<String, String>> toKeyValuePairs(Properties properties) {
        return KeyValuePair.toKeyValuePairs(properties);
    }

    public static void toProperties(File properties, File xml, String comment) throws FileNotFoundException, IOException {
        PropertiesExtensions.toProperties(new FileOutputStream(properties), new FileInputStream(xml), comment);
    }

    public static void toProperties(OutputStream properties, InputStream xml, String comment) throws FileNotFoundException, IOException {
        Properties prop = new Properties();
        prop.loadFromXML(xml);
        prop.store(properties, comment);
    }

    public static void toXml(File properties, File xml, String comment, String encoding) throws FileNotFoundException, IOException {
        PropertiesExtensions.toXml(new FileInputStream(properties), new FileOutputStream(xml), comment, encoding);
    }

    public static void toXml(InputStream properties, OutputStream xml, String comment, String encoding) throws FileNotFoundException, IOException {
        Properties prop = new Properties();
        prop.load(properties);
        prop.storeToXML(xml, comment, encoding);
    }

    private PropertiesExtensions() {
    }
}

