/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.runtime.compiler;

import de.alpharogroup.runtime.compiler.BaseJavaFileManager;
import de.alpharogroup.runtime.compiler.BaseJavaFileObject;
import de.alpharogroup.runtime.compiler.CompilerExtensions;
import de.alpharogroup.runtime.compiler.CompilerRuntimeException;
import de.alpharogroup.runtime.compiler.RuntimeCompilerClassLoader;
import java.util.Arrays;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

public class JavaSourceCompiler<T> {
    private JavaCompiler systemJavaCompiler = ToolProvider.getSystemJavaCompiler();
    private BaseJavaFileManager baseJavaFileManager;
    private RuntimeCompilerClassLoader runtimeCompilerClassLoader;
    private DiagnosticCollector<JavaFileObject> diagnosticCollectors;

    public JavaSourceCompiler() {
        if (this.systemJavaCompiler == null) {
            throw new CompilerRuntimeException("The SystemJavaCompiler was not found.");
        }
        this.runtimeCompilerClassLoader = new RuntimeCompilerClassLoader(this.getClass().getClassLoader());
        this.diagnosticCollectors = new DiagnosticCollector();
        StandardJavaFileManager standardFileManager = this.systemJavaCompiler.getStandardFileManager(this.diagnosticCollectors, null, null);
        this.baseJavaFileManager = new BaseJavaFileManager(standardFileManager, this.runtimeCompilerClassLoader);
    }

    public synchronized Class<T> compile(String packageName, String className, String javaSource) {
        String qualifiedClassName = CompilerExtensions.newQualifiedClassName(packageName, className);
        BaseJavaFileObject javaSourceFileObject = new BaseJavaFileObject(className, javaSource);
        BaseJavaFileObject compiledJavaFileObject = new BaseJavaFileObject(qualifiedClassName);
        this.baseJavaFileManager.initialize(javaSourceFileObject, compiledJavaFileObject);
        JavaCompiler.CompilationTask task = this.systemJavaCompiler.getTask(null, this.baseJavaFileManager, this.diagnosticCollectors, null, null, Arrays.asList(javaSourceFileObject));
        if (!task.call().booleanValue()) {
            String message = CompilerExtensions.generateCompilationStacktrace(this.diagnosticCollectors);
            throw new CompilerRuntimeException(message);
        }
        Class<?> newClass = this.runtimeCompilerClassLoader.findClass(qualifiedClassName);
        return newClass;
    }
}

