/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.runtime.compiler;

import de.alpharogroup.runtime.compiler.CompilerRuntimeException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaFileObject;
import org.apache.commons.lang3.StringUtils;

public class CompilerExtensions {
    public static URI newURIQuietly(String uriString) {
        try {
            URI uri = CompilerExtensions.newURI(uriString);
            return uri;
        }
        catch (URISyntaxException e) {
            throw new CompilerRuntimeException("Given String " + uriString + " does not match to an uri", e);
        }
    }

    public static URI newURI(String uriString) throws URISyntaxException {
        URI uri = new URI(uriString);
        return uri;
    }

    public static String newQualifiedClassName(String packageName, String className) {
        if (StringUtils.isBlank((CharSequence)packageName)) {
            return className;
        }
        return packageName + "." + className;
    }

    public static String getClassNameWithExtension(String className) {
        return className + JavaFileObject.Kind.SOURCE.extension;
    }

    public static String generateCompilationStacktrace(DiagnosticCollector<JavaFileObject> diagnosticCollectors) {
        StringBuilder sb = new StringBuilder();
        for (Diagnostic<JavaFileObject> diagnostic : diagnosticCollectors.getDiagnostics()) {
            sb.append(diagnostic.getMessage(null));
            sb.append("; ");
        }
        return sb.toString();
    }
}

