/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.runtime.compiler;

import de.alpharogroup.runtime.compiler.CompilerExtensions;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;

public class BaseJavaFileObject
extends SimpleJavaFileObject {
    private String javaSource;
    private ByteArrayOutputStream javaByteCode = new ByteArrayOutputStream();

    public BaseJavaFileObject(String baseName, String javaSource) {
        super(CompilerExtensions.newURIQuietly(CompilerExtensions.getClassNameWithExtension(baseName)), JavaFileObject.Kind.SOURCE);
        this.javaSource = javaSource;
    }

    public BaseJavaFileObject(String name) {
        super(CompilerExtensions.newURIQuietly(name), JavaFileObject.Kind.CLASS);
    }

    @Override
    public String getCharContent(boolean ignoreEncodingErrors) {
        return this.javaSource;
    }

    @Override
    public OutputStream openOutputStream() {
        return this.javaByteCode;
    }

    public byte[] getBytes() {
        return this.javaByteCode.toByteArray();
    }
}

