/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.service.rs.streaming;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.StreamingOutput;
import lombok.NonNull;

public class InputStreamStreamingOutput
implements StreamingOutput {
    private final InputStream inputStream;

    public InputStreamStreamingOutput(@NonNull InputStream input) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        this.inputStream = input;
    }

    public void write(@NonNull OutputStream output) throws IOException, WebApplicationException {
        int bytesRead;
        if (output == null) {
            throw new NullPointerException("output is marked non-null but is null");
        }
        byte[] buffer = new byte[4096];
        while ((bytesRead = this.inputStream.read(buffer)) != -1) {
            output.write(buffer, 0, bytesRead);
        }
    }
}

