/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.cxf.rest.client;

import de.alpharogroup.cxf.rest.client.MockX509TrustManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.configuration.jsse.TLSServerParameters;
import org.apache.cxf.configuration.security.ClientAuthentication;
import org.apache.cxf.configuration.security.FiltersType;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.client.ClientConfiguration;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;

public class WebClientExtensions {
    public static final String[] DEFAULT_FILTERS_TYPE_INCLUDES = new String[]{".*_EXPORT_.*", ".*_EXPORT1024_.*", ".*_WITH_DES_.*", ".*_WITH_AES_.*", ".*_WITH_NULL_.*"};
    public static final String[] DEFAULT_FILTERS_TYPE_EXCLUDES = new String[]{".*_DH_anon_.*"};

    public static FiltersType newCipherSuitesFilter() {
        return WebClientExtensions.newCipherSuitesFilter(DEFAULT_FILTERS_TYPE_INCLUDES, DEFAULT_FILTERS_TYPE_EXCLUDES);
    }

    public static FiltersType newCipherSuitesFilter(String[] includes, String[] excludes) {
        FiltersType filtersType = new FiltersType();
        for (String include : includes) {
            filtersType.getInclude().add(include);
        }
        for (String exclude : excludes) {
            filtersType.getExclude().add(exclude);
        }
        return filtersType;
    }

    public static ClientAuthentication newClientAuthentication(boolean want, boolean required) {
        ClientAuthentication clientAuthentication = new ClientAuthentication();
        clientAuthentication.setWant(want);
        clientAuthentication.setRequired(required);
        return clientAuthentication;
    }

    public static HTTPClientPolicy newHTTPClientPolicy(Long connectionTimeout, boolean allowChunking, Long receiveTimeout) {
        HTTPClientPolicy httpClientPolicy = new HTTPClientPolicy();
        httpClientPolicy.setConnectionTimeout(connectionTimeout.longValue());
        httpClientPolicy.setAllowChunking(allowChunking);
        httpClientPolicy.setReceiveTimeout(receiveTimeout.longValue());
        return httpClientPolicy;
    }

    public static JAXRSServerFactoryBean newJAXRSServerFactoryBean(String serverConfigFile, String baseUrl) {
        JAXRSServerFactoryBean bean = new JAXRSServerFactoryBean();
        SpringBusFactory bf = new SpringBusFactory();
        Bus bus = bf.createBus(serverConfigFile);
        bean.setBus(bus);
        bean.setAddress(baseUrl);
        return bean;
    }

    public static KeyStore newKeyStore(String type, String password, File keystoreFile) throws NoSuchAlgorithmException, CertificateException, FileNotFoundException, IOException, KeyStoreException {
        KeyStore keyStore = KeyStore.getInstance(type);
        keyStore.load(new FileInputStream(keystoreFile), password.toCharArray());
        return keyStore;
    }

    public static TLSClientParameters newTLSClientParameters(File keystoreDir, String keystoreFilename, String keystoreType, String keystorePassword) throws UnrecoverableKeyException, NoSuchAlgorithmException, CertificateException, FileNotFoundException, KeyStoreException, IOException {
        File keystoreFile;
        File trustManagersKeystoreFile = keystoreFile = new File(keystoreDir, keystoreFilename);
        String trustManagerAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
        String trustManagersKeystoreType = keystoreType;
        String trustManagersKeystorePassword = keystorePassword;
        boolean disableCNCheck = true;
        String keyManagerAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
        File keyManagersKeystoreFile = keystoreFile;
        String keyManagersKeystoreType = keystoreType;
        String keyManagersKeystorePassword = keystorePassword;
        FiltersType cipherSuitesFilter = WebClientExtensions.newCipherSuitesFilter();
        TLSClientParameters tlsClientParameters = WebClientExtensions.newTLSClientParameters(trustManagersKeystoreFile, trustManagerAlgorithm, trustManagersKeystoreType, trustManagersKeystorePassword, keyManagersKeystoreFile, keyManagerAlgorithm, keyManagersKeystoreType, keyManagersKeystorePassword, cipherSuitesFilter, disableCNCheck);
        return tlsClientParameters;
    }

    public static TLSClientParameters newTLSClientParameters(File trustManagersKeystoreFile, String trustManagerAlgorithm, String trustManagersKeystoreType, String trustManagersKeystorePassword, File keyManagersKeystoreFile, String keyManagerAlgorithm, String keyManagersKeystoreType, String keyManagersKeystorePassword, FiltersType cipherSuitesFilter, boolean disableCNCheck) throws NoSuchAlgorithmException, CertificateException, FileNotFoundException, IOException, KeyStoreException, UnrecoverableKeyException {
        TLSClientParameters tlsClientParameters = new TLSClientParameters();
        tlsClientParameters.setDisableCNCheck(disableCNCheck);
        TrustManager[] tm = WebClientExtensions.resolveTrustManagers(trustManagersKeystoreType, trustManagersKeystorePassword, trustManagersKeystoreFile, trustManagerAlgorithm);
        tlsClientParameters.setTrustManagers(tm);
        KeyManager[] km = WebClientExtensions.resolveKeyManagers(keyManagersKeystoreType, keyManagersKeystorePassword, keyManagersKeystoreFile, keyManagerAlgorithm);
        tlsClientParameters.setKeyManagers(km);
        tlsClientParameters.setCipherSuitesFilter(cipherSuitesFilter);
        return tlsClientParameters;
    }

    public static TLSServerParameters newTLSServerParameters(File trustManagersKeystoreFile, String trustManagerAlgorithm, String trustManagersKeystoreType, String trustManagersKeystorePassword, File keyManagersKeystoreFile, String keyManagerAlgorithm, String keyManagersKeystoreType, String keyManagersKeystorePassword, FiltersType cipherSuitesFilter, ClientAuthentication clientAuthentication) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, FileNotFoundException, IOException, UnrecoverableKeyException {
        TLSServerParameters tlsServerParameters = new TLSServerParameters();
        TrustManager[] tm = WebClientExtensions.resolveTrustManagers(trustManagersKeystoreType, trustManagersKeystorePassword, trustManagersKeystoreFile, trustManagerAlgorithm);
        tlsServerParameters.setTrustManagers(tm);
        KeyManager[] km = WebClientExtensions.resolveKeyManagers(keyManagersKeystoreType, keyManagersKeystorePassword, keyManagersKeystoreFile, keyManagerAlgorithm);
        tlsServerParameters.setKeyManagers(km);
        tlsServerParameters.setCipherSuitesFilter(cipherSuitesFilter);
        tlsServerParameters.setClientAuthentication(clientAuthentication);
        return tlsServerParameters;
    }

    public static KeyManager[] resolveKeyManagers(String type, String password, File keystoreFile, String keyManagerAlgorithm) throws NoSuchAlgorithmException, CertificateException, FileNotFoundException, IOException, KeyStoreException, UnrecoverableKeyException {
        KeyStore keyStore = WebClientExtensions.newKeyStore(type, password, keystoreFile);
        KeyManagerFactory keyFactory = KeyManagerFactory.getInstance(keyManagerAlgorithm);
        keyFactory.init(keyStore, password.toCharArray());
        KeyManager[] keyManagers = keyFactory.getKeyManagers();
        return keyManagers;
    }

    public static TrustManager[] resolveTrustManagers(String type, String password, File keystoreFile, String trustManagerAlgorithm) throws NoSuchAlgorithmException, CertificateException, FileNotFoundException, IOException, KeyStoreException {
        KeyStore keyStore = WebClientExtensions.newKeyStore(type, password, keystoreFile);
        TrustManagerFactory trustFactory = TrustManagerFactory.getInstance(trustManagerAlgorithm);
        trustFactory.init(keyStore);
        TrustManager[] trustManagers = trustFactory.getTrustManagers();
        return trustManagers;
    }

    public static void setClientConfiguration(Object client, File trustManagersKeystoreFile, String trustManagerAlgorithm, String trustManagersKeystoreType, String trustManagersKeystorePassword, File keyManagersKeystoreFile, String keyManagerAlgorithm, String keyManagersKeystoreType, String keyManagersKeystorePassword, FiltersType cipherSuitesFilter, boolean disableCNCheck) throws NoSuchAlgorithmException, CertificateException, FileNotFoundException, IOException, KeyStoreException, UnrecoverableKeyException {
        ClientConfiguration config = WebClient.getConfig((Object)client);
        HTTPConduit httpConduit = config.getHttpConduit();
        TLSClientParameters tlsParams = WebClientExtensions.newTLSClientParameters(trustManagersKeystoreFile, trustManagerAlgorithm, trustManagersKeystoreType, trustManagersKeystorePassword, keyManagersKeystoreFile, keyManagerAlgorithm, keyManagersKeystoreType, keyManagersKeystorePassword, cipherSuitesFilter, disableCNCheck);
        new TLSClientParameters();
        httpConduit.setTlsClientParameters(tlsParams);
    }

    public static void setMockClientAuthentication(Object client) {
        ClientConfiguration config = WebClient.getConfig((Object)client);
        HTTPConduit conduit = config.getHttpConduit();
        TLSClientParameters params = conduit.getTlsClientParameters();
        if (params == null) {
            params = new TLSClientParameters();
            params.setTrustManagers(new TrustManager[]{new MockX509TrustManager()});
            params.setDisableCNCheck(true);
            conduit.setTlsClientParameters(params);
        }
    }

    public static void setTLSClientParameters(Object client, TLSClientParameters tlsClientParameters) {
        ClientConfiguration config = WebClient.getConfig((Object)client);
        HTTPConduit conduit = config.getHttpConduit();
        HTTPClientPolicy httpClientPolicy = conduit.getClient();
        if (httpClientPolicy == null) {
            conduit.setClient(WebClientExtensions.newHTTPClientPolicy(36000L, false, 32000L));
        }
        conduit.setTlsClientParameters(tlsClientParameters);
    }
}

