/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.cxf.rest.client;

import de.alpharogroup.check.Check;
import de.alpharogroup.service.rs.providers.CustomTypeModulesRegistrationProvider;
import java.util.ArrayList;
import java.util.List;
import org.apache.cxf.jaxrs.client.JAXRSClientFactory;
import org.apache.cxf.jaxrs.client.WebClient;

public abstract class AbstractRestClient {
    public static final int DEFAULT_HTTP_PORT = 8080;
    public static final String BASE_URL_PREFIX = "http://localhost";
    public static final String DEFAULT_BASE_URL = "http://localhost:8080";
    private final String baseUrl;
    private final List<Object> providers;

    public AbstractRestClient() {
        this(DEFAULT_BASE_URL);
    }

    public AbstractRestClient(String baseUrl) {
        Check.get().notEmpty((CharSequence)baseUrl, "baseUrl");
        this.baseUrl = baseUrl;
        this.providers = this.newProviders();
    }

    protected List<Object> newProviders() {
        ArrayList<Object> providers = new ArrayList<Object>();
        providers.add(new CustomTypeModulesRegistrationProvider());
        return providers;
    }

    protected <T> T newResource(Class<T> resourceClass) {
        Object resource = JAXRSClientFactory.create((String)this.getBaseUrl(), resourceClass, this.getProviders());
        WebClient.client((Object)resource).accept(new String[]{"application/json"});
        WebClient.client((Object)resource).type("application/json");
        return (T)resource;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public List<Object> getProviders() {
        return this.providers;
    }
}

