/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.service.rs.filter;

import de.alpharogroup.service.rs.Securable;
import de.alpharogroup.service.rs.filter.AuthenticationSecurityContext;
import java.io.IOException;
import java.lang.reflect.Method;
import javax.annotation.Priority;
import javax.net.ssl.SSLException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;

@Securable
@Provider
@Priority(value=1000)
public abstract class AuthenticationFilter
implements ContainerRequestFilter {
    @Context
    private UriInfo info;
    @Context
    private ResourceInfo resourceInfo;
    @Context
    private HttpServletRequest servletRequest;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        try {
            if (this.isSigninRequest(requestContext)) {
                return;
            }
            if (this.isSecured()) {
                String authorizationHeader = requestContext.getHeaderString("Authorization");
                if (authorizationHeader == null) {
                    throw new NotAuthorizedException((Object)"Authorization header must be provided", new Object[0]);
                }
                String token = authorizationHeader.substring("Bearer".length()).trim();
                String username = this.onValidateToken(token);
                requestContext.setSecurityContext(this.newSecurityContext(username));
            }
        }
        catch (Exception e) {
            requestContext.abortWith(this.newFaultResponse());
        }
    }

    protected boolean isSecured() {
        Class resourceClass = this.resourceInfo.getResourceClass();
        Securable securable = resourceClass.getAnnotation(Securable.class);
        if (securable != null) {
            return true;
        }
        Method method = this.resourceInfo.getResourceMethod();
        securable = method.getAnnotation(Securable.class);
        boolean secured = securable != null;
        return secured;
    }

    protected boolean isSigninPath(String path) {
        boolean isSigninPath = path.equals("auth/credentials") || path.equals("auth/form");
        return isSigninPath;
    }

    protected boolean isSigninRequest(ContainerRequestContext requestContext) throws Exception {
        boolean isSigninRequest = false;
        String path = this.info.getPath();
        if (this.isSigninPath(path)) {
            if (!this.servletRequest.isSecure()) {
                throw new SSLException("use https scheme");
            }
            isSigninRequest = true;
        }
        return isSigninRequest;
    }

    protected Response newFaultResponse() {
        Response faultResponse = Response.status((Response.Status)Response.Status.UNAUTHORIZED).header("WWW-Authenticate", (Object)("Basic realm=\"" + this.newRealmValue() + "\"")).build();
        return faultResponse;
    }

    protected String newRealmValue() {
        return "alpharogroup.de";
    }

    protected SecurityContext newSecurityContext(String username) {
        return new AuthenticationSecurityContext(username);
    }

    protected abstract String onValidateToken(String var1) throws Exception;
}

