/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.service.rs.filter;

import de.alpharogroup.service.rs.Securable;
import java.io.IOException;
import java.security.Principal;
import javax.annotation.Priority;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.Provider;

@Securable
@Provider
@Priority(value=1000)
public abstract class AuthenticationFilter
implements ContainerRequestFilter {
    public void filter(ContainerRequestContext requestContext) throws IOException {
        String authorizationHeader = requestContext.getHeaderString("Authorization");
        if (authorizationHeader == null) {
            throw new NotAuthorizedException((Object)"Authorization header must be provided", new Object[0]);
        }
        String token = authorizationHeader.substring("Bearer".length()).trim();
        try {
            String username = this.onValidateToken(token);
            requestContext.setSecurityContext(this.newSecurityContext(username));
        }
        catch (Exception e) {
            requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
        }
    }

    protected abstract String onValidateToken(String var1) throws Exception;

    protected SecurityContext newSecurityContext(final String username) {
        return new SecurityContext(){

            public Principal getUserPrincipal() {
                return new Principal(){

                    @Override
                    public String getName() {
                        return username;
                    }
                };
            }

            public boolean isUserInRole(String role) {
                return true;
            }

            public boolean isSecure() {
                return false;
            }

            public String getAuthenticationScheme() {
                return null;
            }
        };
    }
}

