/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.resourcebundle.locale;

import de.alpharogroup.check.Check;
import de.alpharogroup.resourcebundle.locale.BundleKey;
import de.alpharogroup.resourcebundle.locale.ResourceBundleResolver;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import lombok.NonNull;

public final class ResourceBundleExtensions {
    public static String getString(ResourceBundle resourceBundle, String key, Object ... parameters) throws MissingResourceException {
        return ResourceBundleExtensions.getString(resourceBundle, key, null, parameters);
    }

    public static String getStringQuietly(ResourceBundle resourceBundle, String key, Object ... parameters) {
        return ResourceBundleExtensions.getStringQuietly(resourceBundle, key, null, parameters);
    }

    public static String getString(ResourceBundle resourceBundle, String key, String defaultValue) throws MissingResourceException {
        return ResourceBundleExtensions.getString(resourceBundle, key, defaultValue, new Object[]{null});
    }

    public static String getStringQuietly(ResourceBundle resourceBundle, String key, String defaultValue) {
        return ResourceBundleExtensions.getStringQuietly(resourceBundle, key, defaultValue, new Object[]{null});
    }

    public static String getString(@NonNull ResourceBundle resourceBundle, @NonNull String key, String defaultValue, Object ... parameters) throws MissingResourceException {
        if (resourceBundle == null) {
            throw new NullPointerException("resourceBundle is marked @NonNull but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked @NonNull but is null");
        }
        String value = null;
        value = ResourceBundleExtensions.format(resourceBundle.getString(key), parameters);
        return value;
    }

    public static String format(String value, Object ... parameters) {
        if (parameters != null && 0 < parameters.length) {
            value = MessageFormat.format(value, parameters);
        }
        return value;
    }

    public static String getStringQuietly(@NonNull ResourceBundle resourceBundle, String key, String defaultValue, Object ... parameters) {
        if (resourceBundle == null) {
            throw new NullPointerException("resourceBundle is marked @NonNull but is null");
        }
        Check.get().notEmpty((CharSequence)key, "key");
        String value = null;
        try {
            value = ResourceBundleExtensions.getString(resourceBundle, key, defaultValue, parameters);
        }
        catch (MissingResourceException e) {
            String warnMessage = "Warning:!!!Missing key is '" + key + "'!!!";
            if (defaultValue != null && !defaultValue.isEmpty()) {
                return defaultValue;
            }
            return warnMessage;
        }
        value = ResourceBundleExtensions.format(value, parameters);
        return value;
    }

    public static String getString(String baseName, @NonNull Locale locale, String key, String defaultValue, Object ... parameters) throws MissingResourceException {
        if (locale == null) {
            throw new NullPointerException("locale is marked @NonNull but is null");
        }
        Check.get().notEmpty((CharSequence)baseName, "baseName");
        ResourceBundle resourceBundle = ResourceBundleResolver.getBundle(baseName, locale);
        return ResourceBundleExtensions.getString(resourceBundle, key, defaultValue, parameters);
    }

    public static String getStringQuietly(String baseName, @NonNull Locale locale, String key, String defaultValue, Object ... parameters) {
        if (locale == null) {
            throw new NullPointerException("locale is marked @NonNull but is null");
        }
        Check.get().notEmpty((CharSequence)baseName, "baseName");
        ResourceBundle resourceBundle = ResourceBundleResolver.getBundle(baseName, locale);
        return ResourceBundleExtensions.getStringQuietly(resourceBundle, key, defaultValue, parameters);
    }

    public static String getString(String baseName, Locale locale, String key, Object ... parameters) throws MissingResourceException {
        return ResourceBundleExtensions.getString(baseName, locale, key, null, parameters);
    }

    public static String getString(String baseName, Locale locale, String key) throws MissingResourceException {
        return ResourceBundleExtensions.getString(baseName, locale, key, null, new Object[]{null});
    }

    public static String getString(String baseName, Locale locale, String key, String defaultValue) throws MissingResourceException {
        return ResourceBundleExtensions.getString(baseName, locale, key, defaultValue, new Object[]{null});
    }

    public static String getString(BundleKey bundleKey) throws MissingResourceException {
        return ResourceBundleExtensions.getString(bundleKey.getBaseName(), bundleKey.getLocale(), bundleKey.getResourceBundleKey().getKey(), bundleKey.getResourceBundleKey().getDefaultValue(), bundleKey.getResourceBundleKey().getParameters());
    }

    private ResourceBundleExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

