/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.resourcebundle.inspector.search;

import de.alpharogroup.collections.pairs.KeyValuePair;
import de.alpharogroup.resourcebundle.inspector.search.PropertiesDirectoryWalker;
import de.alpharogroup.resourcebundle.locale.LocaleResolver;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import lombok.NonNull;

public class PropertiesListResolver {
    private final Locale defaultLocale;
    private final List<KeyValuePair<File, Locale>> propertiesList = new ArrayList<KeyValuePair<File, Locale>>();
    private final File rootDir;

    public PropertiesListResolver(@NonNull File rootDir, @NonNull Locale defaultLocale) {
        if (rootDir == null) {
            throw new NullPointerException("rootDir is marked @NonNull but is null");
        }
        if (defaultLocale == null) {
            throw new NullPointerException("defaultLocale is marked @NonNull but is null");
        }
        if (!rootDir.isDirectory()) {
            throw new IllegalArgumentException("rootDir is not a directory.");
        }
        this.rootDir = rootDir;
        this.defaultLocale = defaultLocale;
    }

    public void resolve() throws IOException {
        PropertiesDirectoryWalker walker = new PropertiesDirectoryWalker(){

            protected void handleFile(File file, int depth, Collection<File> results) throws IOException {
                Locale locale = LocaleResolver.resolveLocale(file, PropertiesListResolver.this.defaultLocale, false);
                PropertiesListResolver.this.propertiesList.add(KeyValuePair.builder().key((Object)file).value((Object)locale).build());
            }
        };
        walker.start(this.rootDir);
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public List<KeyValuePair<File, Locale>> getPropertiesList() {
        return this.propertiesList;
    }

    public File getRootDir() {
        return this.rootDir;
    }
}

