/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.resourcebundle.inspector.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class PropertiesLineReader {
    private byte[] inputByteBuffer;
    private int inputLimit = 0;
    private int inputOff = 0;
    private char[] inputCharBuffer;
    private InputStream inputStream;
    private char[] lineBuffer = new char[1024];
    private Reader reader;

    public PropertiesLineReader(InputStream inStream) {
        this.inputStream = inStream;
        this.inputByteBuffer = new byte[8192];
    }

    public PropertiesLineReader(Reader reader) {
        this.reader = reader;
        this.inputCharBuffer = new char[8192];
    }

    public char[] getLineBuffer() {
        return this.lineBuffer;
    }

    public int readLine() throws IOException {
        int len = 0;
        char c = '\u0000';
        boolean skipWhiteSpace = true;
        boolean isCommentLine = false;
        boolean isNewLine = true;
        boolean appendedLineBegin = false;
        boolean precedingBackslash = false;
        boolean skipLineFeed = false;
        while (true) {
            if (this.inputOff >= this.inputLimit) {
                this.inputLimit = this.inputStream == null ? this.reader.read(this.inputCharBuffer) : this.inputStream.read(this.inputByteBuffer);
                this.inputOff = 0;
                if (this.inputLimit <= 0) {
                    if (len == 0 || isCommentLine) {
                        return -1;
                    }
                    return len;
                }
            }
            c = this.inputStream != null ? (char)(0xFF & this.inputByteBuffer[this.inputOff++]) : this.inputCharBuffer[this.inputOff++];
            if (skipLineFeed) {
                skipLineFeed = false;
                if (c == '\n') continue;
            }
            if (skipWhiteSpace) {
                if (c == ' ' || c == '\t' || c == '\f' || !appendedLineBegin && (c == '\r' || c == '\n')) continue;
                skipWhiteSpace = false;
                appendedLineBegin = false;
            }
            if (isNewLine) {
                isNewLine = false;
                if (c == '#' || c == '!') {
                    isCommentLine = true;
                    continue;
                }
            }
            if (c != '\n' && c != '\r') {
                this.lineBuffer[len++] = c;
                if (len == this.lineBuffer.length) {
                    int newLength = this.lineBuffer.length * 2;
                    if (newLength < 0) {
                        newLength = Integer.MAX_VALUE;
                    }
                    char[] buf = new char[newLength];
                    System.arraycopy(this.lineBuffer, 0, buf, 0, this.lineBuffer.length);
                    this.lineBuffer = buf;
                }
                if (c == '\\') {
                    precedingBackslash = !precedingBackslash;
                    continue;
                }
                precedingBackslash = false;
                continue;
            }
            if (isCommentLine || len == 0) {
                isCommentLine = false;
                isNewLine = true;
                skipWhiteSpace = true;
                len = 0;
                continue;
            }
            if (this.inputOff >= this.inputLimit) {
                this.inputLimit = this.inputStream == null ? this.reader.read(this.inputCharBuffer) : this.inputStream.read(this.inputByteBuffer);
                this.inputOff = 0;
                if (this.inputLimit <= 0) {
                    return len;
                }
            }
            if (!precedingBackslash) break;
            --len;
            skipWhiteSpace = true;
            appendedLineBegin = true;
            precedingBackslash = false;
            if (c != '\r') continue;
            skipLineFeed = true;
        }
        return len;
    }
}

