/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.resourcebundle.locale;

import de.alpharogroup.check.Check;
import de.alpharogroup.resourcebundle.locale.BundleKey;
import de.alpharogroup.resourcebundle.locale.ResourceBundleResolver;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;

public final class ResourceBundleExtensions {
    protected static final Logger LOGGER = Logger.getLogger((String)ResourceBundleExtensions.class.getName());

    public static String getString(ResourceBundle resourceBundle, String key, Object ... parameters) throws MissingResourceException {
        return ResourceBundleExtensions.getString(resourceBundle, key, null, parameters);
    }

    public static String getStringQuietly(ResourceBundle resourceBundle, String key, Object ... parameters) {
        return ResourceBundleExtensions.getStringQuietly(resourceBundle, key, null, parameters);
    }

    public static String getString(ResourceBundle resourceBundle, String key, String defaultValue) throws MissingResourceException {
        return ResourceBundleExtensions.getString(resourceBundle, key, defaultValue, new Object[]{null});
    }

    public static String getStringQuietly(ResourceBundle resourceBundle, String key, String defaultValue) {
        return ResourceBundleExtensions.getStringQuietly(resourceBundle, key, defaultValue, new Object[]{null});
    }

    public static String getString(ResourceBundle resourceBundle, String key, String defaultValue, Object ... parameters) throws MissingResourceException {
        Check.get().notNull((Object)resourceBundle, "resourceBundle").notEmpty((CharSequence)key, "key");
        String value = null;
        value = ResourceBundleExtensions.format(resourceBundle.getString(key), parameters);
        return value;
    }

    public static String format(String value, Object ... parameters) {
        if (parameters != null && 0 < parameters.length) {
            value = MessageFormat.format(value, parameters);
        }
        return value;
    }

    public static String getStringQuietly(ResourceBundle resourceBundle, String key, String defaultValue, Object ... parameters) {
        Check.get().notNull((Object)resourceBundle, "resourceBundle").notEmpty((CharSequence)key, "key");
        String value = null;
        try {
            value = ResourceBundleExtensions.getString(resourceBundle, key, defaultValue, parameters);
        }
        catch (MissingResourceException e) {
            String warnMessage = "Warning:!!!Missing key is '" + key + "'!!!";
            if (defaultValue != null && !defaultValue.isEmpty()) {
                LOGGER.warn((Object)warnMessage, (Throwable)e);
                return defaultValue;
            }
            return warnMessage;
        }
        value = ResourceBundleExtensions.format(value, parameters);
        return value;
    }

    public static String getString(String baseName, Locale locale, String key, String defaultValue, Object ... parameters) throws MissingResourceException {
        Check.get().notEmpty((CharSequence)baseName, "baseName").notNull((Object)locale, "locale");
        ResourceBundle resourceBundle = ResourceBundleResolver.getBundle(baseName, locale);
        return ResourceBundleExtensions.getString(resourceBundle, key, defaultValue, parameters);
    }

    public static String getStringQuietly(String baseName, Locale locale, String key, String defaultValue, Object ... parameters) {
        Check.get().notEmpty((CharSequence)baseName, "baseName").notNull((Object)locale, "locale");
        ResourceBundle resourceBundle = ResourceBundleResolver.getBundle(baseName, locale);
        return ResourceBundleExtensions.getStringQuietly(resourceBundle, key, defaultValue, parameters);
    }

    public static String getString(String baseName, Locale locale, String key, Object ... parameters) throws MissingResourceException {
        return ResourceBundleExtensions.getString(baseName, locale, key, null, parameters);
    }

    public static String getString(String baseName, Locale locale, String key) throws MissingResourceException {
        return ResourceBundleExtensions.getString(baseName, locale, key, null, new Object[]{null});
    }

    public static String getString(String baseName, Locale locale, String key, String defaultValue) throws MissingResourceException {
        return ResourceBundleExtensions.getString(baseName, locale, key, defaultValue, new Object[]{null});
    }

    public static String getString(BundleKey bundleKey) throws MissingResourceException {
        return ResourceBundleExtensions.getString(bundleKey.getBaseName(), bundleKey.getLocale(), bundleKey.getResourceBundleKey().getKey(), bundleKey.getResourceBundleKey().getDefaultValue(), bundleKey.getResourceBundleKey().getParameters());
    }

    private ResourceBundleExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

