/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.resourcebundle.locale;

import de.alpharogroup.collections.list.ListExtensions;
import de.alpharogroup.resourcebundle.locale.LocaleResolver;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public final class LocaleExtensions {
    private static List<Locale> availableLocales;

    public static String getLocaleFilenameSuffix(Locale locale) {
        return LocaleExtensions.getLocaleFileSuffix(locale, true, true, false);
    }

    public static String getLocaleFileSuffix(Locale locale, boolean withCountry) {
        return LocaleExtensions.getLocaleFileSuffix(locale, withCountry, false);
    }

    public static String getLocaleFileSuffix(Locale locale, boolean withCountry, boolean withVariant) {
        return LocaleExtensions.getLocaleFileSuffix(locale, withCountry, withVariant, true);
    }

    public static String getLocaleFileSuffix(Locale locale, boolean withCountry, boolean withVariant, boolean withUnderscorePrefix) {
        StringBuilder localizedName = new StringBuilder();
        if (locale != null) {
            if (locale.getLanguage() != null && !locale.getLanguage().isEmpty()) {
                if (withUnderscorePrefix) {
                    localizedName.append("_");
                }
                localizedName.append(locale.getLanguage());
            }
            if (withCountry && locale.getCountry() != null && !locale.getCountry().isEmpty()) {
                localizedName.append("_");
                localizedName.append(locale.getCountry());
            }
            if (withVariant && locale.getVariant() != null && !locale.getVariant().isEmpty()) {
                localizedName.append("_");
                localizedName.append(locale.getVariant());
            }
        }
        return localizedName.toString().trim();
    }

    public static String getLocaleName(Locale locale) {
        return LocaleExtensions.getLocaleFileSuffix(locale, true, true, false);
    }

    public static boolean contains(Locale locale) {
        List<Locale> availableLocales = LocaleExtensions.getAvailableLocales();
        boolean exists = availableLocales.contains(locale);
        return exists;
    }

    public static List<Locale> getAvailableLocales() {
        if (availableLocales == null) {
            Locale[] localesArray = DateFormat.getAvailableLocales();
            availableLocales = Arrays.asList(localesArray);
        }
        return availableLocales;
    }

    public static String getCountryName(String countryCode, Locale inLocale) {
        return LocaleExtensions.getCountryName(countryCode, inLocale, countryCode);
    }

    public static String getCountryName(String countryCode, Locale inLocale, String defaultCountryName) {
        Locale locale = LocaleResolver.getLocale(countryCode);
        if (locale != null) {
            return locale.getDisplayCountry(inLocale);
        }
        return defaultCountryName;
    }

    public static String getLanguageName(String languageCode, Locale inLocale) {
        List<Locale> locales = LocaleResolver.getLocales(languageCode);
        Locale first = (Locale)ListExtensions.getFirst(locales);
        if (first != null) {
            return first.getDisplayLanguage(inLocale);
        }
        return "";
    }

    private LocaleExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

