/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.resourcebundle.config;

import de.alpharogroup.check.Check;
import de.alpharogroup.resourcebundle.properties.PropertiesFileExtensions;
import java.io.IOException;
import java.io.Serializable;
import java.util.Optional;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationPropertiesResolver
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationPropertiesResolver.class);
    public static final String APPLICATION_HTTP_PORT_KEY = "application.http.port";
    public static final String APPLICATION_HTTPS_PORT_KEY = "application.https.port";
    public static final String DEFAULT_CONFIGURATION_PROPERTIES_FILENAME = "config.properties";
    public static final int DEFAULT_HTTP_PORT = 8080;
    public static final int DEFAULT_HTTPS_PORT = 8443;
    private static final long serialVersionUID = 1L;
    private final int defaultHttpPort;
    private final int defaultHttpsPort;
    private final int httpPort;
    private final int httpsPort;
    private final Properties properties;
    private final String propertiesFilename;

    public ConfigurationPropertiesResolver() {
        this(8080, 8443, DEFAULT_CONFIGURATION_PROPERTIES_FILENAME);
    }

    public ConfigurationPropertiesResolver(Integer defaultHttpPort, Integer defaultHttpsPort, String propertiesFilename) {
        Check.get().notNull((Object)defaultHttpPort, "defaultHttpPort").notNull((Object)defaultHttpsPort, "defaultHttpsPort").notNull((Object)propertiesFilename, "propertiesFilename");
        this.defaultHttpPort = defaultHttpPort;
        this.defaultHttpsPort = defaultHttpsPort;
        this.propertiesFilename = propertiesFilename;
        this.properties = this.loadProperties();
        this.httpPort = this.resolveHttpPort();
        this.httpsPort = this.resolveHttpsPort();
    }

    @Deprecated
    private Optional<Integer> getInteger(Properties properties, String propertiesKey) {
        if (properties != null && properties.containsKey(propertiesKey)) {
            String portAsString = properties.getProperty(propertiesKey);
            try {
                Integer port = Integer.valueOf(portAsString);
                return Optional.of(port);
            }
            catch (NumberFormatException e) {
                log.error("Value of given properties key:" + propertiesKey + " is not a number.", (Throwable)e);
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    private Optional<Integer> getOptionalHttpPort() {
        return this.getInteger(this.getProperties(), APPLICATION_HTTP_PORT_KEY);
    }

    private Optional<Integer> getOptionalHttpsPort() {
        return this.getInteger(this.getProperties(), APPLICATION_HTTPS_PORT_KEY);
    }

    protected Properties loadProperties() {
        Properties properties;
        try {
            properties = PropertiesFileExtensions.loadProperties(this.getPropertiesFilename());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return properties;
    }

    private int resolveHttpPort() {
        Optional<Integer> optionalHttpPort = this.getOptionalHttpPort();
        if (optionalHttpPort.isPresent()) {
            return optionalHttpPort.get();
        }
        return this.getDefaultHttpPort();
    }

    private int resolveHttpsPort() {
        Optional<Integer> optionalHttpsPort = this.getOptionalHttpsPort();
        if (optionalHttpsPort.isPresent()) {
            return optionalHttpsPort.get();
        }
        return this.getDefaultHttpsPort();
    }

    public int getDefaultHttpPort() {
        return this.defaultHttpPort;
    }

    public int getDefaultHttpsPort() {
        return this.defaultHttpsPort;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public int getHttpsPort() {
        return this.httpsPort;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getPropertiesFilename() {
        return this.propertiesFilename;
    }
}

