/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.resourcebundle.properties;

import de.alpharogroup.collections.properties.PropertiesExtensions;
import de.alpharogroup.file.FileExtension;
import de.alpharogroup.file.copy.CopyFileExtensions;
import de.alpharogroup.file.read.ReadFileExtensions;
import de.alpharogroup.file.search.FileSearchExtensions;
import de.alpharogroup.lang.ClassExtensions;
import de.alpharogroup.lang.PackageExtensions;
import de.alpharogroup.resourcebundle.file.namefilter.PropertiesResourceBundleFilenameFilter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PropertiesFileExtensions {
    private static final Logger log = LoggerFactory.getLogger(PropertiesFileExtensions.class);

    public static Properties getLocalPropertiesFromClass(Class<?> componentClass, Class<?> defaultClass, Locale locale) throws Exception {
        Properties properties = null;
        properties = componentClass != null ? PropertiesFileExtensions.loadPropertiesFromClassObject(componentClass, locale) : PropertiesFileExtensions.loadPropertiesFromClassObject(defaultClass, locale);
        return properties;
    }

    public static String getProjectName() throws IOException {
        Properties projectProperties = PropertiesFileExtensions.loadProperties("project.properties");
        if (projectProperties != null) {
            String projectName = projectProperties.getProperty("artifactId");
            if (projectName == null) {
                throw new RuntimeException("No properties key 'artifactId' found in the properties file project.properties exist.");
            }
            return projectName;
        }
        throw new RuntimeException("No properties file project.properties exist.");
    }

    public static String getProjectNameQuietly(String defaultName) {
        try {
            PropertiesFileExtensions.getProjectName();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return defaultName;
    }

    public static Map<File, Map<String, List<String>>> getRedundantKeys(File dirToSearch) throws IOException {
        List foundFiles = FileSearchExtensions.findAllFiles((File)dirToSearch, (String)FileSearchExtensions.getSearchFilePattern((String[])new String[]{"properties"}));
        LinkedHashMap linesMap = new LinkedHashMap();
        LinkedHashMap<File, Map<String, List<String>>> fileMap = new LinkedHashMap<File, Map<String, List<String>>>();
        for (File file : foundFiles) {
            List<String> lines = PropertiesFileExtensions.removeComments(file);
            Properties p = PropertiesFileExtensions.loadProperties(file);
            for (Map.Entry<Object, Object> entry : p.entrySet()) {
                String key = ((String)entry.getKey()).trim();
                for (String line : lines) {
                    char nextChar;
                    if (!line.startsWith(key) || (nextChar = line.charAt(key.length())) == '.') continue;
                    if (nextChar == '=' || nextChar == ':' || nextChar == ' ') {
                        List<String> dl;
                        if (!linesMap.containsKey(key)) {
                            dl = new ArrayList<String>();
                            dl.add(line);
                            linesMap.put(key, dl);
                            continue;
                        }
                        dl = (List)linesMap.get(key);
                        dl.add(line);
                        linesMap.put(key, dl);
                        continue;
                    }
                    throw new RuntimeException("nextChar is '" + nextChar + "'");
                }
            }
            LinkedHashMap duplicateKeys = new LinkedHashMap();
            for (Map.Entry entry : linesMap.entrySet()) {
                if (1 >= ((List)entry.getValue()).size()) continue;
                duplicateKeys.put(entry.getKey(), entry.getValue());
            }
            if (0 >= duplicateKeys.size()) continue;
            fileMap.put(file, duplicateKeys);
        }
        return fileMap;
    }

    public static Properties loadProperties(Class<?> clazz, String name) throws IOException {
        InputStream is;
        Properties properties = PropertiesFileExtensions.loadProperties(name);
        if (properties == null && (is = ClassExtensions.getResourceAsStream(clazz.getClass(), (String)name)) != null) {
            properties = new Properties();
            properties.load(is);
        }
        return properties;
    }

    public static Properties loadProperties(Class<?> clazz, String packagePath, String fileName) throws IOException {
        return PropertiesFileExtensions.loadProperties(clazz, packagePath + fileName);
    }

    public static Properties loadProperties(File propertiesFile) throws IOException {
        return PropertiesExtensions.loadProperties((File)propertiesFile);
    }

    public static Properties loadProperties(String packagePath) throws IOException {
        Properties properties = null;
        URL url = ClassExtensions.getResource((String)packagePath);
        if (url != null) {
            properties = new Properties();
            properties.load(url.openStream());
        } else {
            InputStream is = ClassExtensions.getResourceAsStream((String)packagePath);
            if (is != null) {
                properties = new Properties();
                properties.load(is);
            }
        }
        return properties;
    }

    public static Properties loadProperties(String packagePath, String fileName) throws IOException {
        StringBuilder sb = new StringBuilder();
        packagePath = FilenameUtils.normalize((String)packagePath);
        String slash = "/";
        if (packagePath.startsWith("/")) {
            if (packagePath.endsWith("/")) {
                sb.append(packagePath.substring(1, packagePath.length()));
            } else {
                sb.append(packagePath.substring(1, packagePath.length())).append("/");
            }
        } else if (packagePath.endsWith("/")) {
            sb.append(packagePath);
        } else {
            sb.append(packagePath).append("/");
        }
        packagePath = sb.toString().trim();
        sb = new StringBuilder();
        if (fileName.startsWith("/")) {
            sb.append(fileName.substring(1, fileName.length()));
        }
        fileName = sb.toString().trim();
        return PropertiesFileExtensions.loadProperties(packagePath + fileName);
    }

    public static <T> Properties loadProperties(T object, String propertiesFilename) {
        Properties properties = null;
        String packagePath = PackageExtensions.getPackagePathWithSlash(object);
        String propertiespath = packagePath + propertiesFilename;
        try {
            properties = PropertiesFileExtensions.loadProperties(object.getClass(), propertiespath);
        }
        catch (IOException e) {
            log.error("Loading properties file '" + propertiespath + "' with method 'PropertiesExtensions.loadProperties(object.getClass(), propertiespath)' failed.", (Throwable)e);
        }
        if (properties == null) {
            try {
                properties = PropertiesFileExtensions.getLocalPropertiesFromClass(object.getClass(), object.getClass(), null);
            }
            catch (Exception e) {
                log.error("Loading properties file '" + propertiespath + "' with method 'PropertiesExtensions.getLocalPropertiesFromClass(object.getClass(), object.getClass(), null)' failed.", (Throwable)e);
            }
        }
        return properties;
    }

    public static Properties loadPropertiesFromClassObject(Class<?> clazz, Locale locale) throws IOException {
        if (null == clazz) {
            throw new IllegalArgumentException("Class object must not be null!!!");
        }
        StringBuilder propertiesName = new StringBuilder();
        Properties properties = null;
        String language = null;
        String filename = null;
        String pathAndFilename = null;
        File propertiesFile = null;
        String absoluteFilename = null;
        String packagePath = PackageExtensions.getPackagePathWithSlash(clazz);
        ArrayList<String> missedFiles = new ArrayList<String>();
        if (null != locale) {
            String country;
            propertiesName.append(clazz.getSimpleName());
            language = locale.getLanguage();
            if (null != language && !language.isEmpty()) {
                propertiesName.append("_").append(language);
            }
            if (null != (country = locale.getCountry()) && !country.isEmpty()) {
                propertiesName.append("_").append(country);
            }
            propertiesName.append(FileExtension.PROPERTIES.getExtension());
            filename = propertiesName.toString().trim();
            pathAndFilename = packagePath + filename;
            URL url = ClassExtensions.getResource(clazz, (String)filename);
            if (url != null) {
                absoluteFilename = url.getFile();
            } else {
                missedFiles.add("File with filename '" + filename + "' does not exists.");
            }
            if (null != absoluteFilename) {
                propertiesFile = new File(absoluteFilename);
            }
            if (null != propertiesFile && propertiesFile.exists()) {
                properties = PropertiesFileExtensions.loadProperties(pathAndFilename);
            } else {
                propertiesName = new StringBuilder();
                if (null != locale) {
                    propertiesName.append(clazz.getSimpleName());
                    language = locale.getLanguage();
                    if (null != language && !language.isEmpty()) {
                        propertiesName.append("_").append(language);
                    }
                    propertiesName.append(FileExtension.PROPERTIES.getExtension());
                    filename = propertiesName.toString().trim();
                    pathAndFilename = packagePath + filename;
                    url = ClassExtensions.getResource(clazz, (String)filename);
                    if (url != null) {
                        absoluteFilename = url.getFile();
                    } else {
                        missedFiles.add("File with filename '" + filename + "' does not exists.");
                    }
                    if (null != absoluteFilename) {
                        propertiesFile = new File(absoluteFilename);
                    }
                    if (null != propertiesFile && propertiesFile.exists()) {
                        properties = PropertiesFileExtensions.loadProperties(pathAndFilename);
                    }
                }
            }
        }
        if (null == properties) {
            propertiesName = new StringBuilder();
            propertiesName.append(clazz.getSimpleName()).append(FileExtension.PROPERTIES.getExtension());
            filename = propertiesName.toString().trim();
            pathAndFilename = packagePath + filename;
            URL url = ClassExtensions.getResource(clazz, (String)filename);
            if (url != null) {
                absoluteFilename = url.getFile();
            } else {
                properties = PropertiesFileExtensions.loadProperties(pathAndFilename);
                missedFiles.add("File with filename '" + filename + "' does not exists.");
            }
            if (null != absoluteFilename) {
                propertiesFile = new File(absoluteFilename);
            }
            if (null != propertiesFile && propertiesFile.exists()) {
                properties = PropertiesFileExtensions.loadProperties(pathAndFilename);
            }
        }
        if (properties == null) {
            for (String string : missedFiles) {
                log.info(string);
            }
        }
        return properties;
    }

    public static File newBackupOf(File file) throws IOException {
        return CopyFileExtensions.newBackupOf((File)file, (Charset)Charset.forName("ISO-8859-1"), (Charset)Charset.forName("UTF-8"));
    }

    public static List<String> removeComments(File propertiesFile) throws IOException {
        if (propertiesFile != null && !propertiesFile.getName().matches(FileSearchExtensions.getSearchFilePattern((String[])new String[]{"properties"}))) {
            throw new IllegalArgumentException("The given file is not an properties file.");
        }
        List lines = ReadFileExtensions.readLinesInList((File)propertiesFile);
        Iterator itr = lines.iterator();
        while (itr.hasNext()) {
            String line = (String)itr.next();
            if (!line.startsWith("#") && line.trim().length() != 0) continue;
            itr.remove();
        }
        return lines;
    }

    public static Set<String> resolveAvailableLanguages(String bundlepackage, String bundlename) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        File root = new File(loader.getResource(bundlepackage.replace('.', '/')).getFile());
        File[] files = root.listFiles(new PropertiesResourceBundleFilenameFilter(bundlename));
        TreeSet<String> languages = new TreeSet<String>();
        for (File file : files) {
            String language = file.getName().replaceAll("^" + bundlename + "(_)?|\\.properties$", "");
            if (language == null || language.isEmpty()) continue;
            languages.add(language);
        }
        return languages;
    }

    private PropertiesFileExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

