/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.resourcebundle.inspector.search;

import de.alpharogroup.check.Check;
import de.alpharogroup.collections.pairs.KeyValuePair;
import de.alpharogroup.resourcebundle.inspector.search.PropertiesDirectoryWalker;
import de.alpharogroup.resourcebundle.locale.LocaleResolver;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;

public class PropertiesListResolver {
    private final List<KeyValuePair<File, Locale>> propertiesList = new ArrayList<KeyValuePair<File, Locale>>();
    private final File rootDir;
    private final Locale defaultLocale;

    public PropertiesListResolver(File rootDir, Locale defaultLocale) {
        Check.get().notNull((Object)rootDir, "rootDir");
        Check.get().notNull((Object)defaultLocale, "defaultLocale");
        if (!rootDir.isDirectory()) {
            throw new IllegalArgumentException("rootDir is not a directory.");
        }
        this.rootDir = rootDir;
        this.defaultLocale = defaultLocale;
    }

    public void resolve() throws IOException {
        PropertiesDirectoryWalker walker = new PropertiesDirectoryWalker(){

            protected void handleFile(File file, int depth, Collection<File> results) throws IOException {
                Locale locale = LocaleResolver.resolveLocale(file, PropertiesListResolver.this.defaultLocale, false);
                PropertiesListResolver.this.propertiesList.add(KeyValuePair.builder().key((Object)file).value((Object)locale).build());
            }
        };
        walker.start(this.rootDir);
    }

    public List<KeyValuePair<File, Locale>> getPropertiesList() {
        return this.propertiesList;
    }

    public File getRootDir() {
        return this.rootDir;
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }
}

