/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.resourcebundle.config;

import de.alpharogroup.check.Check;
import de.alpharogroup.resourcebundle.properties.PropertiesFileExtensions;
import java.io.IOException;
import java.io.Serializable;
import java.util.Optional;
import java.util.Properties;

public class ConfigurationPropertiesResolver
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_CONFIGURATION_PROPERTIES_FILENAME = "config.properties";
    public static final int DEFAULT_HTTP_PORT = 8080;
    public static final int DEFAULT_HTTPS_PORT = 8443;
    public static final String APPLICATION_HTTP_PORT_KEY = "application.http.port";
    public static final String APPLICATION_HTTPS_PORT_KEY = "application.https.port";
    private final int defaultHttpPort;
    private final int defaultHttpsPort;
    private final int httpPort;
    private final int httpsPort;
    private final String propertiesFilename;
    private final Properties properties;

    public ConfigurationPropertiesResolver() {
        this(8080, 8443, DEFAULT_CONFIGURATION_PROPERTIES_FILENAME);
    }

    public ConfigurationPropertiesResolver(Integer defaultHttpPort, Integer defaultHttpsPort, String propertiesFilename) {
        Check.get().notNull((Object)defaultHttpPort, "defaultHttpPort").notNull((Object)defaultHttpsPort, "defaultHttpsPort").notNull((Object)propertiesFilename, "propertiesFilename");
        this.defaultHttpPort = defaultHttpPort;
        this.defaultHttpsPort = defaultHttpsPort;
        this.propertiesFilename = propertiesFilename;
        this.properties = this.loadProperties();
        this.httpPort = this.resolveHttpPort();
        this.httpsPort = this.resolveHttpsPort();
    }

    private Optional<Integer> getOptionalHttpPort() {
        if (this.getProperties() != null && this.getProperties().containsKey(APPLICATION_HTTP_PORT_KEY)) {
            String httpPortString = this.getProperties().getProperty(APPLICATION_HTTP_PORT_KEY);
            try {
                Integer httpPort = Integer.valueOf(httpPortString);
                return Optional.of(httpPort);
            }
            catch (NumberFormatException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    private Optional<Integer> getOptionalHttpsPort() {
        if (this.getProperties().containsKey(APPLICATION_HTTPS_PORT_KEY)) {
            String httpsPortString = this.getProperties().getProperty(APPLICATION_HTTPS_PORT_KEY);
            try {
                Integer httpsPort = Integer.valueOf(httpsPortString);
                return Optional.of(httpsPort);
            }
            catch (NumberFormatException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    protected Properties loadProperties() {
        Properties properties;
        try {
            properties = PropertiesFileExtensions.loadProperties(this.getPropertiesFilename());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return properties;
    }

    private int resolveHttpPort() {
        Optional<Integer> optionalHttpPort = this.getOptionalHttpPort();
        if (optionalHttpPort.isPresent()) {
            return optionalHttpPort.get();
        }
        return this.getDefaultHttpPort();
    }

    private int resolveHttpsPort() {
        Optional<Integer> optionalHttpsPort = this.getOptionalHttpsPort();
        if (optionalHttpsPort.isPresent()) {
            return optionalHttpsPort.get();
        }
        return this.getDefaultHttpsPort();
    }

    public int getDefaultHttpPort() {
        return this.defaultHttpPort;
    }

    public int getDefaultHttpsPort() {
        return this.defaultHttpsPort;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public int getHttpsPort() {
        return this.httpsPort;
    }

    public String getPropertiesFilename() {
        return this.propertiesFilename;
    }

    public Properties getProperties() {
        return this.properties;
    }
}

