/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.resourcebundle.inspector.search.processor;

import de.alpharogroup.file.search.FileSearchExtensions;
import de.alpharogroup.resourcebundle.inspector.search.processor.FilterProcessor;
import de.alpharogroup.resourcebundle.inspector.search.processor.KeySearchBean;
import de.alpharogroup.resourcebundle.inspector.search.processor.UsedKeysSearchResult;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FileUtils;

public class UsedKeysSearchFilter
implements FilterProcessor<KeySearchBean, UsedKeysSearchResult> {
    @Override
    public UsedKeysSearchResult process(KeySearchBean searchModel) {
        UsedKeysSearchResult result;
        try {
            List foundFiles = FileSearchExtensions.findFilesWithFilter((File)searchModel.getSearchDir(), (String[])searchModel.getFileExtensions());
            result = UsedKeysSearchResult.builder().used(new Properties()).build();
            result.setSearchModel(searchModel);
            for (File file : foundFiles) {
                if (searchModel.getExclude().contains(file)) continue;
                String fileContent = FileUtils.readFileToString((File)file, (String)"UTF-8");
                for (Object key : searchModel.getBase().keySet()) {
                    String k = "\"" + key.toString().trim() + "\"";
                    if (!fileContent.contains(k)) continue;
                    result.getUsed().put(key, searchModel.getBase().get(key));
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }
}

