/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.resourcebundle.inspector.search;

import de.alpharogroup.resourcebundle.inspector.core.KeyValueLists;
import de.alpharogroup.resourcebundle.inspector.io.PropertiesLineReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;

public class DuplicatePropertiesKeyInspector {
    private final KeyValueLists result;

    public static Map<String, List<String>> findRedundantValues(Properties properties) {
        List keys;
        LinkedHashMap reverseEntries = new LinkedHashMap();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!reverseEntries.containsKey(value)) {
                keys = new ArrayList<String>();
                keys.add(key);
                reverseEntries.put(value, keys);
                continue;
            }
            keys = (List)reverseEntries.get(value);
            keys.add(key);
        }
        LinkedHashMap<String, List<String>> redundantValues = new LinkedHashMap<String, List<String>>();
        for (Map.Entry entry : reverseEntries.entrySet()) {
            String key = (String)entry.getKey();
            keys = (List)entry.getValue();
            if (1 >= keys.size()) continue;
            redundantValues.put(key, keys);
        }
        return redundantValues;
    }

    public DuplicatePropertiesKeyInspector(File propertiesFile) throws IOException {
        this.result = this.findDuplicateKeys(propertiesFile);
    }

    public DuplicatePropertiesKeyInspector(InputStream inputStream) throws IOException {
        this.result = this.findDuplicateKeys(inputStream);
    }

    private KeyValueLists findDuplicateKeys(File propertiesFile) throws IOException {
        return this.findDuplicateKeys(new FileInputStream(propertiesFile));
    }

    private KeyValueLists findDuplicateKeys(InputStream inputStream) throws IOException {
        TreeSet<String> set = new TreeSet<String>();
        KeyValueLists keyValueLists = this.read(inputStream);
        List<String> keys = keyValueLists.getKeys();
        for (int i = 0; i < keys.size(); ++i) {
            String currentValue;
            List<String> duplicateValues;
            String key = keys.get(i);
            if (set.add(key)) continue;
            if (keyValueLists.getDuplicateMap().containsKey(key)) {
                keyValueLists.getDuplicateMap().put(key, keyValueLists.getDuplicateMap().get(key) + 1);
                duplicateValues = keyValueLists.getDuplicateValueMap().get(key);
                currentValue = keyValueLists.getValues().get(i);
                duplicateValues.add(currentValue);
                continue;
            }
            keyValueLists.getDuplicateMap().put(key, 1);
            keyValueLists.getDuplicateValueMap().put(key, new ArrayList());
            duplicateValues = keyValueLists.getDuplicateValueMap().get(key);
            currentValue = keyValueLists.getValues().get(i);
            duplicateValues.add(currentValue);
        }
        return keyValueLists;
    }

    private KeyValueLists read(InputStream inputStream) throws IOException {
        return this.read(new PropertiesLineReader(inputStream));
    }

    private KeyValueLists read(PropertiesLineReader propertiesLineReader) throws IOException {
        int limit;
        char[] buffer = new char[1024];
        KeyValueLists keyValueLists = new KeyValueLists();
        while ((limit = propertiesLineReader.readLine()) >= 0) {
            int keyLength;
            char c = '\u0000';
            int valueStart = limit;
            boolean hasSep = false;
            boolean precedingBackslash = false;
            for (keyLength = 0; keyLength < limit; ++keyLength) {
                c = propertiesLineReader.getLineBuffer()[keyLength];
                if (!(c != '=' && c != ':' || precedingBackslash)) {
                    valueStart = keyLength + 1;
                    hasSep = true;
                    break;
                }
                if (!(c != ' ' && c != '\t' && c != '\f' || precedingBackslash)) {
                    valueStart = keyLength + 1;
                    break;
                }
                precedingBackslash = c == '\\' ? !precedingBackslash : false;
            }
            while (valueStart < limit) {
                c = propertiesLineReader.getLineBuffer()[valueStart];
                if (c != ' ' && c != '\t' && c != '\f') {
                    if (hasSep || c != '=' && c != ':') break;
                    hasSep = true;
                }
                ++valueStart;
            }
            char[] lineBuffer = propertiesLineReader.getLineBuffer();
            String key = this.readPartOfLine(lineBuffer, 0, keyLength, buffer);
            String value = this.readPartOfLine(lineBuffer, valueStart, limit - valueStart, buffer);
            keyValueLists.getKeys().add(key);
            keyValueLists.getValues().add(value);
        }
        return keyValueLists;
    }

    private String readPartOfLine(char[] in, int off, int len, char[] buffer) {
        if (buffer.length < len) {
            int newLength = len * 2;
            if (newLength < 0) {
                newLength = Integer.MAX_VALUE;
            }
            buffer = new char[newLength];
        }
        char[] out = buffer;
        int outputLength = 0;
        int end = off + len;
        while (off < end) {
            int aChar;
            if ((aChar = in[off++]) == 92) {
                if ((aChar = in[off++]) == 117) {
                    int value = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        aChar = in[off++];
                        switch (aChar) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                value = (value << 4) + aChar - 48;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                value = (value << 4) + 10 + aChar - 97;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                value = (value << 4) + 10 + aChar - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                    }
                    out[outputLength++] = (char)value;
                    continue;
                }
                if (aChar == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                }
                out[outputLength++] = aChar;
                continue;
            }
            out[outputLength++] = aChar;
        }
        return new String(out, 0, outputLength);
    }

    public KeyValueLists getResult() {
        return this.result;
    }
}

