package resource.system.domain;

import hbm.domain.BaseBusinessObject;

import java.util.Date;

import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;


@Getter
@Setter
@ToString(callSuper=true)
@EqualsAndHashCode(callSuper=true)
public class Resource extends BaseBusinessObject<Integer> {
	/**
	 * The serial Version UID
	 */
	private static final long serialVersionUID = 1L;
	/** The checksum from this resource. */
	private String checksum;
	/** The binary data from this resource. */
	private Byte[] content;
	/** The content type from this resource. */
	private String contentType;
	/** The date when this resource is created in the database. */
	private Date created;
	/**
	 * A flag that indicates that the resource is deleted from the user. Will be deleted in batch process.
	 */
	private Boolean deletedFlag;
	/** A description for this resource. */
	private String description;
	/** The filename from this resource. */
	private String filename;
	/** The size from this resource. */
	private String filesize;
}
