/*
 * Decompiled with CFR 0.152.
 */
package resource.system.service;

import hbm.dao.jpa.EntityManagerDao;
import hbm.service.jpa.AbstractBusinessService;
import java.util.List;
import javax.persistence.Query;
import net.sourceforge.jaulp.collections.ListUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import resource.system.daos.ResourcesDao;
import resource.system.model.Resources;
import resource.system.service.api.ResourcesService;
import resource.system.service.util.HqlStringCreator;

@Transactional
@Service(value="resourcesService")
public class ResourcesBusinessService
extends AbstractBusinessService<Resources, Integer, ResourcesDao>
implements ResourcesService {
    private static final long serialVersionUID = 1L;

    @Autowired
    public void setResourcesDao(ResourcesDao ResourcesDao2) {
        this.setDao((EntityManagerDao)ResourcesDao2);
    }

    @Override
    public Resources getManPlaceholder() {
        List<Resources> Resources2 = this.find("default profile photo for male users", "man_placeholder.jpg", null, null);
        return (Resources)ListUtils.getFirst(Resources2);
    }

    @Override
    public Resources getWomanPlaceholder() {
        List<Resources> Resources2 = this.find("default profile photo for female users", "woman_placeholder.jpg", null, null);
        return (Resources)ListUtils.getFirst(Resources2);
    }

    @Override
    public Resources getDefaultPlaceholder() {
        List<Resources> Resources2 = this.find("default profile photo for default users", "default_placeholder.jpg", null, null);
        return (Resources)ListUtils.getFirst(Resources2);
    }

    @Override
    public Resources findByName(String filename) {
        List<Resources> Resources2 = this.find(null, filename, null, null);
        return (Resources)ListUtils.getFirst(Resources2);
    }

    @Override
    public Resources findByDescription(String description) {
        List<Resources> Resources2 = this.find(description, null, null, null);
        return (Resources)ListUtils.getFirst(Resources2);
    }

    @Override
    public List<Resources> find(String description, String filename, String filesize, String contentType) {
        String hqlString = HqlStringCreator.forResources(description, filename, filesize, contentType);
        Query query = this.getQuery(hqlString);
        if (description != null && !description.isEmpty()) {
            query.setParameter("description", (Object)description);
        }
        if (filename != null && !filename.isEmpty()) {
            query.setParameter("filename", (Object)filename);
        }
        if (filesize != null && !filesize.isEmpty()) {
            query.setParameter("filesize", (Object)filesize);
        }
        if (contentType != null && !contentType.isEmpty()) {
            query.setParameter("contentType", (Object)contentType);
        }
        List Resources2 = query.getResultList();
        return Resources2;
    }
}

