/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.resource.system.rest;

import de.alpharogroup.date.CreateDateExtensions;
import de.alpharogroup.domain.DomainObject;
import de.alpharogroup.email.messages.Mimetypes;
import de.alpharogroup.file.checksum.Algorithm;
import de.alpharogroup.file.checksum.ChecksumExtensions;
import de.alpharogroup.io.StreamExtensions;
import de.alpharogroup.resource.system.domain.Resource;
import de.alpharogroup.resource.system.rest.api.ResourcesResource;
import de.alpharogroup.resource.system.rest.streaming.ResourceStreamingOutput;
import de.alpharogroup.resource.system.service.api.ResourceService;
import de.alpharogroup.service.rs.AbstractRestfulResource;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import javax.activation.DataHandler;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.io.IOUtils;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.log4j.Logger;

public class ResourcesRestResource
extends AbstractRestfulResource<Integer, Resource, ResourceService>
implements ResourcesResource {
    private static final Logger LOG = Logger.getLogger((String)ResourcesRestResource.class.getName());

    @Override
    public Response download(String name) {
        Resource resource = ((ResourceService)this.getDomainService()).findByName(name);
        return Response.ok((Object)this.getResourceStreamingOutput(resource)).build();
    }

    @Override
    public Response downloadById(Integer id) {
        Resource resource = (Resource)((ResourceService)this.getDomainService()).read((Serializable)id);
        return Response.ok((Object)this.getResourceStreamingOutput(resource)).build();
    }

    private String getElementFromContentDisposition(Attachment attachment, String element) {
        String[] contentDispositions;
        MultivaluedMap multivaluedMap = attachment.getHeaders();
        for (String contentDisposition : contentDispositions = ((String)multivaluedMap.getFirst((Object)"Content-Disposition")).split(";")) {
            if (!contentDisposition.trim().startsWith(element)) continue;
            String[] keyValue = contentDisposition.split("=");
            String value = keyValue[1].trim();
            return value;
        }
        return null;
    }

    private String getFileName(Attachment attachment) {
        String element = this.getElementFromContentDisposition(attachment, "filename");
        if (element != null) {
            String filename = element.replaceAll("\"", "");
            return filename;
        }
        return null;
    }

    private StreamingOutput getResourceStreamingOutput(Resource resource) {
        return new ResourceStreamingOutput(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Response upload(Attachment attachment) {
        DataHandler dataHandler = attachment.getDataHandler();
        InputStream inputStream = null;
        String fileName = this.getFileName(attachment);
        String description = this.getElementFromContentDisposition(attachment, "description");
        inputStream = dataHandler.getInputStream();
        String contentType = Mimetypes.getExtension((String)fileName);
        byte[] byteArray = IOUtils.toByteArray((InputStream)inputStream);
        Resource resource = Resource.builder().filename(fileName).description(description).contentType(contentType).content(byteArray).filesize(byteArray.length + "").created(CreateDateExtensions.now()).checksum(ChecksumExtensions.getChecksumQuietly((byte[])byteArray, (String)Algorithm.SHA_256.getAlgorithm())).deletedFlag(Boolean.valueOf(false)).build();
        ((ResourceService)this.getDomainService()).create((DomainObject)resource);
        if (inputStream == null) return Response.ok((Object)"upload success").build();
        try {
            StreamExtensions.close((InputStream)inputStream);
            return Response.ok((Object)"upload success").build();
        }
        catch (IOException e) {
            LOG.error((Object)"Error occured by close inputstream.", (Throwable)e);
        }
        return Response.ok((Object)"upload success").build();
        catch (Exception e) {
            try {
                LOG.error((Object)"Error occured by upload attachment.", (Throwable)e);
                if (inputStream == null) return Response.ok((Object)"upload success").build();
            }
            catch (Throwable throwable) {
                if (inputStream == null) throw throwable;
                try {
                    StreamExtensions.close(inputStream);
                    throw throwable;
                }
                catch (IOException e2) {
                    LOG.error((Object)"Error occured by close inputstream.", (Throwable)e2);
                }
                throw throwable;
            }
            try {
                StreamExtensions.close((InputStream)inputStream);
                return Response.ok((Object)"upload success").build();
            }
            catch (IOException e3) {
                LOG.error((Object)"Error occured by close inputstream.", (Throwable)e3);
            }
            return Response.ok((Object)"upload success").build();
        }
    }
}

