/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.resource.system.service;

import de.alpharogroup.db.dao.jpa.EntityManagerDao;
import de.alpharogroup.db.entity.BaseEntity;
import de.alpharogroup.db.entitymapper.EntityDOMapper;
import de.alpharogroup.lang.ObjectExtensions;
import de.alpharogroup.resource.system.daos.ResourcesDao;
import de.alpharogroup.resource.system.domain.Resource;
import de.alpharogroup.resource.system.entities.Resources;
import de.alpharogroup.resource.system.mapper.ResourcesMapper;
import de.alpharogroup.resource.system.service.api.ResourceService;
import de.alpharogroup.resource.system.service.api.ResourcesService;
import de.alpharogroup.service.domain.AbstractDomainService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service(value="resourceDomainService")
public class ResourceDomainService
extends AbstractDomainService<Integer, Resource, Resources, ResourcesDao, ResourcesMapper>
implements ResourceService {
    @Autowired
    private ResourcesService resourcesService;

    @Autowired
    public void setResourcesDao(ResourcesDao resourcesDao) {
        this.setDao((EntityManagerDao)resourcesDao);
    }

    public Resource create(Resource domainObject) {
        Resources resources = (Resources)ObjectExtensions.copyQuietly((Object)new Resources(), (Object)((Object)domainObject));
        domainObject.setId(((ResourcesDao)this.getDao()).save((BaseEntity)resources));
        return domainObject;
    }

    public Resource read(Integer id) {
        Resources resources = (Resources)((ResourcesDao)this.getDao()).get((Serializable)id);
        Resource resource = (Resource)((Object)ObjectExtensions.copyQuietly((Object)((Object)new Resource()), (Object)resources));
        return resource;
    }

    public void update(Resource domainObject) {
        Resources resources = (Resources)((ResourcesDao)this.getDao()).get((Serializable)domainObject.getId());
        ObjectExtensions.copyQuietly((Object)resources, (Object)((Object)domainObject));
        ((ResourcesDao)this.getDao()).merge((BaseEntity)resources);
    }

    @Autowired
    public void setResourcesMapper(ResourcesMapper resourcesMapper) {
        this.setMapper((EntityDOMapper)resourcesMapper);
    }

    @Override
    public Resource findByName(String filename) {
        Resources resources = this.resourcesService.findByName(filename);
        Resource resource = Resource.builder().build();
        ObjectExtensions.copyQuietly((Object)((Object)resource), (Object)resources);
        return resource;
    }

    @Override
    public Resource findByDescription(String description) {
        Resources resources = this.resourcesService.findByDescription(description);
        Resource resource = Resource.builder().build();
        ObjectExtensions.copyQuietly((Object)((Object)resource), (Object)resources);
        return resource;
    }

    @Override
    public List<Resource> find(String description, String filename, String filesize, String contentType) {
        ArrayList<Resource> resourcesDomainObjects = new ArrayList<Resource>();
        List resourcesEntities = this.resourcesService.find(description, filename, filesize, contentType);
        for (Resources resources : resourcesEntities) {
            Resource resource = Resource.builder().build();
            ObjectExtensions.copyQuietly((Object)((Object)resource), (Object)resources);
            resourcesDomainObjects.add(resource);
        }
        return resourcesDomainObjects;
    }

    @Override
    public Resource getManPlaceholder() {
        Resources resources = this.resourcesService.getManPlaceholder();
        Resource resource = Resource.builder().build();
        ObjectExtensions.copyQuietly((Object)((Object)resource), (Object)resources);
        return resource;
    }

    @Override
    public Resource getWomanPlaceholder() {
        Resources resources = this.resourcesService.getWomanPlaceholder();
        Resource resource = Resource.builder().build();
        ObjectExtensions.copyQuietly((Object)((Object)resource), (Object)resources);
        return resource;
    }

    @Override
    public Resource getDefaultPlaceholder() {
        Resources resources = this.resourcesService.getDefaultPlaceholder();
        Resource resource = Resource.builder().build();
        ObjectExtensions.copyQuietly((Object)((Object)resource), (Object)resources);
        return resource;
    }

    public ResourcesService getResourcesService() {
        return this.resourcesService;
    }

    public void setResourcesService(ResourcesService resourcesService) {
        this.resourcesService = resourcesService;
    }
}

