/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.resource.system.application.model;

import de.alpharogroup.date.ConvertDateExtensions;
import de.alpharogroup.file.checksum.Algorithm;
import de.alpharogroup.file.checksum.ChecksumExtensions;
import de.alpharogroup.file.read.ReadFileExtensions;
import de.alpharogroup.lang.ObjectExtensions;
import de.alpharogroup.resource.system.application.model.ResourcesModel;
import de.alpharogroup.resource.system.entities.Resources;
import de.alpharogroup.resource.system.factories.ResourceSystemFactory;
import java.io.File;

public class ModelSynchronizer {
    public static void synchronize(Resources toSynchronize, Resources withImage) {
        ObjectExtensions.copyQuietly((Object)toSynchronize, (Object)withImage);
    }

    public static Resources convert(ResourcesModel resourcesModel) {
        Resources resources = ResourceSystemFactory.getInstance().newResources(resourcesModel.getDescription(), resourcesModel.getFilename(), resourcesModel.getFilesize(), resourcesModel.getContentType(), resourcesModel.getContent(), resourcesModel.getCreated(), resourcesModel.isDeletedFlag(), resourcesModel.getChecksum());
        return resources;
    }

    public static void equalise(Resources resources, ResourcesModel resourcesModel) {
        resources.setChecksum(resourcesModel.getChecksum());
        resources.setContent(resourcesModel.getContent());
        resources.setContentType(resourcesModel.getContentType());
        resources.setCreated(resourcesModel.getCreated());
        resources.setDeletedFlag(resourcesModel.isDeletedFlag());
        resources.setDescription(resourcesModel.getDescription());
        resources.setFilename(resourcesModel.getFilename());
        resources.setFilesize(resourcesModel.getFilesize());
    }

    public static ResourcesModel toResourceModel(File file, String contentType, String description) {
        ResourcesModel resourcesModel = new ResourcesModel();
        resourcesModel.setContent(ReadFileExtensions.toByteArray((File)file));
        resourcesModel.setContentType(contentType);
        resourcesModel.setDescription(description);
        resourcesModel.setFilename(file.getName());
        resourcesModel.setFilesize(file.length() + "");
        resourcesModel.setChecksum(ChecksumExtensions.getChecksumQuietly((File)file, (Algorithm)Algorithm.SHA_256));
        resourcesModel.setCreated(ConvertDateExtensions.toDate((long)file.lastModified()));
        resourcesModel.setDeletedFlag(Boolean.FALSE);
        return resourcesModel;
    }
}

