/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.db.resource.bundles.rest;

import de.alpharogroup.collections.pairs.KeyValuePair;
import de.alpharogroup.collections.pairs.Quattro;
import de.alpharogroup.db.resource.bundles.domain.BundleApplication;
import de.alpharogroup.db.resource.bundles.domain.BundleName;
import de.alpharogroup.db.resource.bundles.domain.Resourcebundle;
import de.alpharogroup.db.resource.bundles.rest.api.ResourcebundlesResource;
import de.alpharogroup.db.resource.bundles.service.api.ResourcebundleService;
import de.alpharogroup.resourcebundle.locale.LocaleResolver;
import de.alpharogroup.service.rs.AbstractRestfulResource;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.ws.rs.core.Response;

public class ResourcebundlesRestResource
extends AbstractRestfulResource<Integer, Resourcebundle, ResourcebundleService>
implements ResourcebundlesResource {
    @Override
    public Resourcebundle find(String bundleappname, String baseName, String locale, String key) {
        BundleApplication bundleApplication = ((ResourcebundleService)this.getDomainService()).find(bundleappname);
        Locale loc = LocaleResolver.resolveLocale((String)locale);
        return ((ResourcebundleService)this.getDomainService()).find(bundleApplication, baseName, loc, key);
    }

    @Override
    public Response findResourceBundles(String bundleappname, String baseName, String locale) {
        BundleApplication bundleApplication = ((ResourcebundleService)this.getDomainService()).find(bundleappname);
        Locale loc = LocaleResolver.resolveLocale((String)locale);
        List resourceBundles = ((ResourcebundleService)this.getDomainService()).findResourceBundles(bundleApplication, baseName, loc);
        return Response.ok((Object)resourceBundles).build();
    }

    @Override
    public Resourcebundle get(String id) {
        ResourcebundleService resourcebundleService = (ResourcebundleService)this.getDomainService();
        Resourcebundle resourcebundle = (Resourcebundle)resourcebundleService.read((Serializable)Integer.valueOf(id));
        return resourcebundle;
    }

    @Override
    public Response getBundleApp(String name) {
        ResourcebundleService resourcebundleService = (ResourcebundleService)this.getDomainService();
        BundleApplication bundleApplication = resourcebundleService.find(name);
        return Response.ok((Object)bundleApplication).build();
    }

    @Override
    public Response getOrCreateNewBundleName(String bundleappname, String baseName, String locale) {
        BundleApplication bundleApplication = ((ResourcebundleService)this.getDomainService()).find(bundleappname);
        Locale loc = LocaleResolver.resolveLocale((String)locale);
        BundleName bundleName = ((ResourcebundleService)this.getDomainService()).getOrCreateNewBundleName(bundleApplication, baseName, loc);
        return Response.ok((Object)bundleName).build();
    }

    @Override
    public Response getProperties(String bundleappname, String baseName, String locale) {
        ResourcebundleService resourcebundleService = (ResourcebundleService)this.getDomainService();
        BundleApplication bundleApplication = resourcebundleService.find(bundleappname);
        Properties properties = ((ResourcebundleService)this.getDomainService()).getProperties(bundleApplication, baseName, locale);
        if (properties == null) {
            properties = new Properties();
        }
        return Response.ok((Object)properties).build();
    }

    @Override
    public Response getResponseString(String bundleappname, String baseName, String locale, String key) {
        ResourcebundleService resourcebundleService = (ResourcebundleService)this.getDomainService();
        BundleApplication bundleApplication = ((ResourcebundleService)this.getDomainService()).find(bundleappname);
        String result = resourcebundleService.getString(bundleApplication, baseName, locale, key);
        return Response.ok((Object)KeyValuePair.builder().key((Object)key).value((Object)result).build()).build();
    }

    @Override
    public Response getString(String bundleappname, String baseName, String locale, String key) {
        ResourcebundleService resourcebundleService = (ResourcebundleService)this.getDomainService();
        BundleApplication bundleApplication = ((ResourcebundleService)this.getDomainService()).find(bundleappname);
        String result = resourcebundleService.getString(bundleApplication, baseName, locale, key);
        return Response.ok((Object)KeyValuePair.builder().key((Object)key).value((Object)result).build()).build();
    }

    @Override
    public Response getString(String bundleappname, String baseName, String locale, String key, String[] params) {
        ResourcebundleService resourcebundleService = (ResourcebundleService)this.getDomainService();
        BundleApplication bundleApplication = ((ResourcebundleService)this.getDomainService()).find(bundleappname);
        String result = resourcebundleService.getString(bundleApplication, baseName, locale, key, (Object[])params);
        return Response.ok((Object)KeyValuePair.builder().key((Object)key).value((Object)result).build()).build();
    }

    @Override
    public Response saveOrUpdateEntry(String bundleappname, String baseName, String locale, String key, String value) {
        Resourcebundle domainObject = ((ResourcebundleService)this.getDomainService()).saveOrUpdateEntry(bundleappname, baseName, locale, key, value);
        return Response.ok((Object)domainObject).build();
    }

    @Override
    public Response updateProperties(Quattro<Properties, String, String, Locale> quattro) {
        Properties properties = (Properties)quattro.getTopLeft();
        String bundleappname = (String)quattro.getTopRight();
        String baseName = (String)quattro.getBottomLeft();
        Locale locale = (Locale)quattro.getBottomRight();
        BundleApplication bundleApplication = ((ResourcebundleService)this.getDomainService()).find(bundleappname);
        BundleName bundleName = ((ResourcebundleService)this.getDomainService()).updateProperties(bundleApplication, properties, baseName, locale);
        return Response.ok((Object)bundleName).build();
    }
}

