/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.db.resource.bundles.entities;

import de.alpharogroup.db.entity.name.unique.ExtraLargeUNameBaseEntity;
import de.alpharogroup.db.resource.bundles.entities.LanguageLocales;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="bundle_applications")
public class BundleApplications
extends ExtraLargeUNameBaseEntity<Integer>
implements Cloneable {
    private static final long serialVersionUID = 1L;
    public static final String BASE_BUNDLE_APPLICATION = "base-bundle-application";
    @ManyToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="default_locale_id", nullable=true, referencedColumnName="id", foreignKey=@ForeignKey(name="FK_BUNDLE_APPLICATIONS_DEFAULT_LOCALE_ID"))
    private LanguageLocales defaultLocale;
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="bundle_application_language_locales", joinColumns={@JoinColumn(name="application_id", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="language_locales_id", referencedColumnName="id")})
    private Set<LanguageLocales> supportedLocales = new HashSet<LanguageLocales>();

    BundleApplications(String name, LanguageLocales defaultLocale, Set<LanguageLocales> supportedLocales) {
        super(name);
        this.defaultLocale = defaultLocale;
        this.supportedLocales = supportedLocales;
    }

    public static BundleApplicationsBuilder builder() {
        return new BundleApplicationsBuilder();
    }

    public LanguageLocales getDefaultLocale() {
        return this.defaultLocale;
    }

    public Set<LanguageLocales> getSupportedLocales() {
        return this.supportedLocales;
    }

    public void setDefaultLocale(LanguageLocales defaultLocale) {
        this.defaultLocale = defaultLocale;
    }

    public void setSupportedLocales(Set<LanguageLocales> supportedLocales) {
        this.supportedLocales = supportedLocales;
    }

    public String toString() {
        return "BundleApplications(defaultLocale=" + this.getDefaultLocale() + ", supportedLocales=" + this.getSupportedLocales() + ")";
    }

    public BundleApplications() {
    }

    public static class BundleApplicationsBuilder {
        private String name;
        private LanguageLocales defaultLocale;
        private Set<LanguageLocales> supportedLocales;

        BundleApplicationsBuilder() {
        }

        public BundleApplicationsBuilder name(String name) {
            this.name = name;
            return this;
        }

        public BundleApplicationsBuilder defaultLocale(LanguageLocales defaultLocale) {
            this.defaultLocale = defaultLocale;
            return this;
        }

        public BundleApplicationsBuilder supportedLocales(Set<LanguageLocales> supportedLocales) {
            this.supportedLocales = supportedLocales;
            return this;
        }

        public BundleApplications build() {
            return new BundleApplications(this.name, this.defaultLocale, this.supportedLocales);
        }

        public String toString() {
            return "BundleApplications.BundleApplicationsBuilder(name=" + this.name + ", defaultLocale=" + this.defaultLocale + ", supportedLocales=" + this.supportedLocales + ")";
        }
    }
}

