/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.db.resource.bundles.entities;

import de.alpharogroup.db.entity.version.VersionableBaseEntity;
import de.alpharogroup.db.resource.bundles.entities.BaseNames;
import de.alpharogroup.db.resource.bundles.entities.LanguageLocales;
import java.beans.ConstructorProperties;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.ForeignKey;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="bundlenames")
public class BundleNames
extends VersionableBaseEntity<Integer>
implements Cloneable {
    private static final long serialVersionUID = 1L;
    @ManyToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="base_name_id", nullable=true, referencedColumnName="id", foreignKey=@ForeignKey(name="FK_BUNDLENAMES_BASE_NAME_ID"))
    private BaseNames baseName;
    @ManyToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="locale_id", nullable=true, referencedColumnName="id", foreignKey=@ForeignKey(name="FK_BUNDLENAMES_LOCALE_ID"))
    private LanguageLocales locale;
    @Column(name="filepath", length=4096)
    private String filepath;

    public static BundleNamesBuilder builder() {
        return new BundleNamesBuilder();
    }

    public BundleNamesBuilder toBuilder() {
        return new BundleNamesBuilder().baseName(this.baseName).locale(this.locale).filepath(this.filepath);
    }

    public BaseNames getBaseName() {
        return this.baseName;
    }

    public LanguageLocales getLocale() {
        return this.locale;
    }

    public String getFilepath() {
        return this.filepath;
    }

    public void setBaseName(BaseNames baseName) {
        this.baseName = baseName;
    }

    public void setLocale(LanguageLocales locale) {
        this.locale = locale;
    }

    public void setFilepath(String filepath) {
        this.filepath = filepath;
    }

    public String toString() {
        return "BundleNames(baseName=" + this.getBaseName() + ", locale=" + this.getLocale() + ", filepath=" + this.getFilepath() + ")";
    }

    public BundleNames() {
    }

    @ConstructorProperties(value={"baseName", "locale", "filepath"})
    public BundleNames(BaseNames baseName, LanguageLocales locale, String filepath) {
        this.baseName = baseName;
        this.locale = locale;
        this.filepath = filepath;
    }

    public static class BundleNamesBuilder {
        private BaseNames baseName;
        private LanguageLocales locale;
        private String filepath;

        BundleNamesBuilder() {
        }

        public BundleNamesBuilder baseName(BaseNames baseName) {
            this.baseName = baseName;
            return this;
        }

        public BundleNamesBuilder locale(LanguageLocales locale) {
            this.locale = locale;
            return this;
        }

        public BundleNamesBuilder filepath(String filepath) {
            this.filepath = filepath;
            return this;
        }

        public BundleNames build() {
            return new BundleNames(this.baseName, this.locale, this.filepath);
        }

        public String toString() {
            return "BundleNames.BundleNamesBuilder(baseName=" + this.baseName + ", locale=" + this.locale + ", filepath=" + this.filepath + ")";
        }
    }
}

