/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.db.resource.bundles.entities;

import de.alpharogroup.db.entity.version.VersionableBaseEntity;
import de.alpharogroup.db.resource.bundles.entities.BaseNames;
import de.alpharogroup.db.resource.bundles.entities.LanguageLocales;
import java.beans.ConstructorProperties;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.ForeignKey;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="bundlenames")
public class BundleNames
extends VersionableBaseEntity<Integer>
implements Cloneable {
    private static final long serialVersionUID = 1L;
    @ManyToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="base_name_id", nullable=true, referencedColumnName="id", foreignKey=@ForeignKey(name="FK_BUNDLENAMES_BASE_NAME_ID"))
    private BaseNames baseName;
    @ManyToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="locale_id", nullable=true, referencedColumnName="id", foreignKey=@ForeignKey(name="FK_BUNDLENAMES_LOCALE_ID"))
    private LanguageLocales locale;

    public static BundleNamesBuilder builder() {
        return new BundleNamesBuilder();
    }

    public BundleNamesBuilder toBuilder() {
        return new BundleNamesBuilder().baseName(this.baseName).locale(this.locale);
    }

    public BaseNames getBaseName() {
        return this.baseName;
    }

    public LanguageLocales getLocale() {
        return this.locale;
    }

    public void setBaseName(BaseNames baseName) {
        this.baseName = baseName;
    }

    public void setLocale(LanguageLocales locale) {
        this.locale = locale;
    }

    public String toString() {
        return "BundleNames(baseName=" + this.getBaseName() + ", locale=" + this.getLocale() + ")";
    }

    public BundleNames() {
    }

    @ConstructorProperties(value={"baseName", "locale"})
    public BundleNames(BaseNames baseName, LanguageLocales locale) {
        this.baseName = baseName;
        this.locale = locale;
    }

    public static class BundleNamesBuilder {
        private BaseNames baseName;
        private LanguageLocales locale;

        BundleNamesBuilder() {
        }

        public BundleNamesBuilder baseName(BaseNames baseName) {
            this.baseName = baseName;
            return this;
        }

        public BundleNamesBuilder locale(LanguageLocales locale) {
            this.locale = locale;
            return this;
        }

        public BundleNames build() {
            return new BundleNames(this.baseName, this.locale);
        }

        public String toString() {
            return "BundleNames.BundleNamesBuilder(baseName=" + this.baseName + ", locale=" + this.locale + ")";
        }
    }
}

