/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.db.resource.bundles.service;

import de.alpharogroup.collections.list.ListExtensions;
import de.alpharogroup.collections.map.CacheableMap;
import de.alpharogroup.db.entitymapper.EntityDOMapper;
import de.alpharogroup.db.repository.api.GenericRepository;
import de.alpharogroup.db.resource.bundles.domain.Resourcebundle;
import de.alpharogroup.db.resource.bundles.entities.Resourcebundles;
import de.alpharogroup.db.resource.bundles.mapper.ResourcebundlesMapper;
import de.alpharogroup.db.resource.bundles.repositories.ResourcebundlesRepository;
import de.alpharogroup.db.resource.bundles.service.DatabaseListResourceBundle;
import de.alpharogroup.db.resource.bundles.service.api.ResourcebundleService;
import de.alpharogroup.db.resource.bundles.service.api.ResourcebundlesService;
import de.alpharogroup.db.resource.bundles.service.util.HqlStringCreator;
import de.alpharogroup.resourcebundle.locale.BundleKey;
import de.alpharogroup.resourcebundle.locale.LocaleExtensions;
import de.alpharogroup.resourcebundle.locale.LocaleResolver;
import de.alpharogroup.resourcebundle.locale.ResourceBundleExtensions;
import de.alpharogroup.service.domain.AbstractDomainService;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.persistence.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service(value="resourcebundleDomainService")
public class ResourcebundleDomainService
extends AbstractDomainService<Integer, Resourcebundle, Resourcebundles, ResourcebundlesRepository, ResourcebundlesMapper>
implements ResourcebundleService {
    @Autowired
    private ResourcebundlesService resourcebundlesService;
    private final CacheableMap<String, String, DatabaseListResourceBundle> cache = new CacheableMap<String, String, DatabaseListResourceBundle>(){

        public DatabaseListResourceBundle newValue(String baseName, String locale) {
            return new DatabaseListResourceBundle(baseName, LocaleResolver.resolveLocale((String)locale), ResourcebundleDomainService.this.resourcebundlesService);
        }
    };

    @Override
    public Resourcebundle contains(String baseName, Locale locale, String key) {
        return this.find(baseName, locale, key);
    }

    @Override
    public Resourcebundle find(String baseName, Locale locale, String key) {
        return this.find(baseName, LocaleExtensions.getLocaleFilenameSuffix((Locale)locale), key);
    }

    @Override
    public Resourcebundle find(String baseName, String locale, String key) {
        return (Resourcebundle)((Object)ListExtensions.getFirst(this.find(baseName, locale, key, null)));
    }

    @Override
    public List<Resourcebundle> find(String baseName, String locale, String key, String value) {
        String hqlString = HqlStringCreator.forResourcebundles((String)baseName, (String)locale, (String)key);
        Query query = ((ResourcebundlesRepository)this.getRepository()).getQuery(hqlString);
        if (baseName != null && !baseName.isEmpty()) {
            query.setParameter("baseName", (Object)baseName);
        }
        if (locale != null && !locale.isEmpty()) {
            query.setParameter("locale", (Object)locale);
        }
        if (key != null && !key.isEmpty()) {
            query.setParameter("key", (Object)key);
        }
        if (value != null && !value.isEmpty()) {
            query.setParameter("value", (Object)value);
        }
        List entities = query.getResultList();
        List bos = ((ResourcebundlesMapper)this.getMapper()).toDomainObjects(entities);
        return bos;
    }

    @Override
    public List<Resourcebundle> findResourceBundles(String baseName, Locale locale) {
        return this.find(baseName, LocaleExtensions.getLocaleFilenameSuffix((Locale)locale), null, null);
    }

    private DatabaseListResourceBundle getDatabaseListResourceBundle(String baseName, String locale) {
        return (DatabaseListResourceBundle)this.cache.getValue((Object)baseName, (Object)locale);
    }

    @Override
    public Properties getProperties(String baseName, Locale locale) {
        return this.resourcebundlesService.getProperties(baseName, locale);
    }

    @Override
    public Properties getProperties(String baseName, String locale) {
        return this.resourcebundlesService.getProperties(baseName, locale);
    }

    @Override
    public Resourcebundle getResourcebundle(String baseName, Locale locale, String key) {
        return this.find(baseName, locale, key);
    }

    @Override
    public String getString(BundleKey bundleKey) {
        return this.getString(bundleKey.getBaseName(), LocaleExtensions.getLocaleFilenameSuffix((Locale)bundleKey.getLocale()), bundleKey.getResourceBundleKey().getKey(), bundleKey.getResourceBundleKey().getDefaultValue(), bundleKey.getResourceBundleKey().getParameters());
    }

    @Override
    public String getString(String baseName, String locale, String key) {
        return this.getString(baseName, locale, key, null, null);
    }

    @Override
    public String getString(String baseName, String locale, String key, Object[] params) {
        return this.getString(baseName, locale, key, null, params);
    }

    @Override
    public String getString(String baseName, String locale, String key, String defaultValue) {
        return this.getString(baseName, locale, key, defaultValue, null);
    }

    @Override
    public String getString(String baseName, String locale, String key, String defaultValue, Object[] params) {
        DatabaseListResourceBundle listResourceBundle = this.getDatabaseListResourceBundle(baseName, locale);
        String value = ResourceBundleExtensions.getString((ResourceBundle)listResourceBundle, (String)key, (String)defaultValue, (Object[])params);
        return value;
    }

    @Autowired
    public void setResourcebundlesMapper(ResourcebundlesMapper mapper) {
        this.setMapper((EntityDOMapper)mapper);
    }

    @Autowired
    public void setResourcebundlesRepository(ResourcebundlesRepository repository) {
        this.setRepository((GenericRepository)repository);
    }

    @Override
    public void updateProperties(Properties properties, String baseName, Locale locale) {
        this.resourcebundlesService.updateProperties(null, properties, baseName, locale);
    }

    @Override
    public void updateProperties(Properties properties, String baseName, Locale locale, boolean update) {
    }
}

