/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.random;

import java.math.BigDecimal;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RandomUtils {
    private static SecureRandom secureRandom;

    public static BigDecimal getRandomBigDecimal(int afterComma, int beforeComma) {
        return new BigDecimal(RandomUtils.getRandomFloatString(afterComma, beforeComma));
    }

    public static Byte getRandomByte() {
        return RandomUtils.randomByte();
    }

    public static Byte[] getRandomByteArray(int length) {
        Byte[] randomByteArray = new Byte[length];
        for (int i = 0; i < length; ++i) {
            randomByteArray[i] = RandomUtils.getRandomByte();
        }
        return randomByteArray;
    }

    public static <T> T getRandomEntry(List<T> list) {
        return list.get(RandomUtils.getRandomIndex(list));
    }

    public static <K, V> Object getRandomEntry(Map<K, V> map) {
        Object[] entries = map.values().toArray();
        return entries[RandomUtils.randomInt(entries.length)];
    }

    public static <T extends Enum<?>> T getRandomEnum(Class<T> clazz) {
        return (T)RandomUtils.getRandomEnum((Enum[])clazz.getEnumConstants());
    }

    public static <T extends Enum<?>> T getRandomEnum(String classname) {
        if (classname != null && !classname.isEmpty()) {
            Class<?> enumClass = null;
            try {
                enumClass = Class.forName(classname);
                return (T)RandomUtils.getRandomEnum(enumClass);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        return null;
    }

    public static <T extends Enum<?>> T getRandomEnum(T obj) {
        if (obj != null) {
            Class<?> clazz = obj.getClass();
            return (T)RandomUtils.getRandomEnum(clazz);
        }
        return null;
    }

    public static <T extends Enum<?>> T getRandomEnum(T[] values) {
        return values[RandomUtils.randomInt(values.length)];
    }

    public static Float getRandomFloat(int afterComma, int beforeComma) {
        return Float.valueOf(RandomUtils.randomFloat(afterComma, beforeComma));
    }

    private static String getRandomFloatString(int afterComma, int beforeComma) {
        String nachkommastellen = RandomUtils.getRandomNumericString(afterComma);
        String vorkommastellen = RandomUtils.getRandomNumericString(beforeComma);
        String result = nachkommastellen + "." + vorkommastellen;
        return result;
    }

    public static <T> int getRandomIndex(Collection<T> list) {
        return RandomUtils.randomInt(list.size());
    }

    public static <K, V> Object getRandomKey(Map<K, V> map) {
        Set<K> keySet = map.keySet();
        Object[] keys = keySet.toArray();
        return keys[RandomUtils.randomInt(keys.length)];
    }

    public static String getRandomNumericString() {
        int maxLength = Math.min(RandomUtils.randomInt(1000), 1024);
        StringBuilder sb = new StringBuilder(maxLength);
        for (int i = 0; i < maxLength; ++i) {
            sb.append(RandomUtils.randomInt());
        }
        return sb.toString();
    }

    public static String getRandomNumericString(int length) {
        String randomNumber = RandomUtils.getRandomString("0123456789", length);
        return randomNumber;
    }

    public static String getRandomString(int length) {
        int maxLength = Math.min(length, 1024);
        StringBuilder sb = new StringBuilder(maxLength);
        for (int i = 0; i < maxLength; ++i) {
            sb.append(RandomUtils.randomChar());
        }
        return sb.toString();
    }

    public static String getRandomString(String chars, int length) {
        StringBuffer ergebnis = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            ergebnis.append(RandomUtils.randomChar(chars));
        }
        return ergebnis.toString();
    }

    public static String getRandomString(String[] array) {
        return array[RandomUtils.randomInt(array.length)];
    }

    public static boolean randomBoolean() {
        return RandomUtils.randomInt(2) == 0;
    }

    public static byte randomByte() {
        return (byte)RandomUtils.randomInt(255);
    }

    public static byte[] randomByteArray(int length) {
        byte[] randomByteArray = new byte[length];
        for (int i = 0; i < length; ++i) {
            randomByteArray[i] = RandomUtils.randomByte();
        }
        return randomByteArray;
    }

    public static char randomChar() {
        if (secureRandom.nextBoolean()) {
            return (char)(secureRandom.nextInt(26) + 65);
        }
        return (char)secureRandom.nextInt(10);
    }

    public static char randomChar(String string) {
        return string.charAt(RandomUtils.randomInt(string.length()));
    }

    public static double randomDouble(double range) {
        if (secureRandom != null) {
            return secureRandom.nextDouble() * range;
        }
        return Math.random() * range;
    }

    public static double randomDoubleBetween(double start, double end) {
        return start + RandomUtils.randomDouble(end - start);
    }

    public static double randomDoubleBetween(double start, double end, String pattern) {
        DecimalFormat formatter = new DecimalFormat(pattern);
        String rd = formatter.format(RandomUtils.randomDoubleBetween(start, end));
        try {
            return formatter.parse(rd).doubleValue();
        }
        catch (ParseException e) {
            throw new NumberFormatException("Could not be parsed:" + rd);
        }
    }

    public static float randomFloat(float range) {
        if (secureRandom != null) {
            return (float)(secureRandom.nextDouble() * (double)range);
        }
        return (float)(Math.random() * (double)range);
    }

    public static float randomFloat(int afterComma, int beforeComma) {
        return Float.parseFloat(RandomUtils.getRandomFloatString(afterComma, beforeComma));
    }

    public static float randomFloatBetween(float start, float end) {
        return start + RandomUtils.randomFloat(end - start);
    }

    public static float randomFloatBetween(float start, float end, String pattern) {
        DecimalFormat formatter = new DecimalFormat(pattern);
        String rf = formatter.format(RandomUtils.randomFloatBetween(start, end));
        try {
            return formatter.parse(rf).floatValue();
        }
        catch (ParseException e) {
            throw new NumberFormatException("Could not be parsed:" + rf);
        }
    }

    public static int randomInt() {
        return RandomUtils.randomInt(10);
    }

    public static int randomInt(int range) {
        if (secureRandom != null) {
            return (int)(secureRandom.nextDouble() * (double)range);
        }
        return (int)(Math.random() * (double)range);
    }

    public static int randomIntBetween(int start, int end) {
        return start + RandomUtils.randomInt(end - start);
    }

    static {
        try {
            secureRandom = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }
}

