/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.random.date;

import de.alpharogroup.random.RandomUtils;
import java.security.SecureRandom;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import net.sourceforge.jaulp.date.CalculateDateUtils;

public class RandomDateUtils {
    public static Date dateBefore(Date date) {
        return RandomDateUtils.dateBefore(date, 10000);
    }

    public static Date dateBefore(Date date, int range) {
        return CalculateDateUtils.substractDaysFromDate((Date)date, (int)range);
    }

    public static Date dateAfter(Date date, int range) {
        return CalculateDateUtils.addDays((Date)date, (int)RandomUtils.randomInt(range));
    }

    public static Date dateAfter(Date date) {
        return RandomDateUtils.dateAfter(date, RandomUtils.randomInt(10000));
    }

    public static Date randomDate(Date from) {
        SecureRandom secrand = new SecureRandom();
        double randDouble = -secrand.nextDouble() * (double)from.getTime();
        double randomDouble = (double)from.getTime() - secrand.nextDouble();
        double result = randDouble / 99999.0 * (randomDouble / 99999.0);
        return new Date((long)result);
    }

    public static Date randomDatebetween(Date start, Date end) {
        SecureRandom secran = new SecureRandom();
        long randomLong = (long)((double)start.getTime() + secran.nextDouble() * (double)(end.getTime() - start.getTime()));
        return new Date(randomLong);
    }

    public static Date randomDateBetween(Date from, int startDays, int endDays) {
        return RandomDateUtils.dateAfter(from, RandomUtils.randomIntBetween(startDays, endDays));
    }

    public static String randomDatebetween(long startDate, long endDate, String format) {
        SecureRandom secrand = new SecureRandom();
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        long randomLong = (long)((double)startDate + secrand.nextDouble() * (double)(endDate - startDate));
        return sdf.format(new Date(randomLong));
    }

    public static String randomDatebetween(long startDate, long endDate) {
        return RandomDateUtils.randomDatebetween(startDate, endDate, "dd.MM.yyyy HH:mm:ss");
    }

    public static Date randomBirthday() {
        Date now = new Date(System.currentTimeMillis());
        Date past = RandomDateUtils.dateBefore(now, 20000);
        Date recentlyPast = RandomDateUtils.dateBefore(now, 3000);
        Date randomBirthday = RandomDateUtils.randomBirthday(recentlyPast, past);
        return randomBirthday;
    }

    public static Date randomBirthday(Date from, Date till) {
        Date randomBirthday = RandomDateUtils.randomDatebetween(from, till);
        return randomBirthday;
    }

    public static Timestamp getTimestamp(Date date) {
        GregorianCalendar gregCal = new GregorianCalendar();
        gregCal.setTime(date);
        gregCal.set(11, 0);
        gregCal.set(12, 0);
        gregCal.set(13, 0);
        gregCal.set(14, 0);
        return new Timestamp(gregCal.getTime().getTime());
    }

    public static Timestamp getTimestamp() {
        return RandomDateUtils.getTimestamp(new Date());
    }
}

