/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.random;

import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import lombok.NonNull;

public class SecureRandomBean {
    public static final String DEFAULT_ALGORITHM = "SHA1PRNG";
    public static final String DEFAULT_PROVIDER = "SUN";
    private String algorithm;
    private String provider;

    public static SecureRandomBean builder() {
        return new SecureRandomBean();
    }

    private SecureRandomBean() {
    }

    public SecureRandomBean algorithm(@NonNull String algorithm) {
        if (algorithm == null) {
            throw new NullPointerException("algorithm is marked non-null but is null");
        }
        this.algorithm = algorithm;
        return this;
    }

    public SecureRandom build() throws NoSuchAlgorithmException, NoSuchProviderException {
        if (this.algorithm != null && this.provider != null) {
            return SecureRandom.getInstance(this.algorithm, this.provider);
        }
        if (this.algorithm != null) {
            return SecureRandom.getInstance(this.algorithm);
        }
        return SecureRandom.getInstance(DEFAULT_ALGORITHM);
    }

    public SecureRandomBean provider(@NonNull String provider) {
        if (provider == null) {
            throw new NullPointerException("provider is marked non-null but is null");
        }
        this.provider = provider;
        return this;
    }
}

