/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.random;

import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureRandomBuilder {
    public static final String DEFAULT_ALGORITHM = "SHA1PRNG";
    private static final Logger logger = LoggerFactory.getLogger((String)SecureRandomBuilder.class.getName());
    private String algorithm;
    private String provider;

    private static SecureRandomBuilder builder() {
        return new SecureRandomBuilder();
    }

    public static SecureRandomBuilder getInstance() {
        return SecureRandomBuilder.builder();
    }

    public static SecureRandomBuilder getInstance(String algorithm) {
        return SecureRandomBuilder.builder().algorithm(algorithm);
    }

    public static SecureRandomBuilder getInstance(String algorithm, String provider) {
        return SecureRandomBuilder.builder().algorithm(algorithm).provider(provider);
    }

    private SecureRandomBuilder() {
    }

    public SecureRandomBuilder algorithm(@Nonnull String algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    public SecureRandom build() throws NoSuchAlgorithmException, NoSuchProviderException {
        if (this.algorithm != null && this.provider != null) {
            return SecureRandom.getInstance(this.algorithm, this.provider);
        }
        if (this.algorithm != null) {
            return SecureRandom.getInstance(this.algorithm);
        }
        return SecureRandom.getInstance(DEFAULT_ALGORITHM);
    }

    public SecureRandom buildQueitly() {
        SecureRandom secureRandom = null;
        try {
            secureRandom = this.build();
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("The specified algorithm is not available from the specified provider.", (Throwable)e);
        }
        catch (NoSuchProviderException e) {
            logger.error("The specified provider is not registered in the security provider list.", (Throwable)e);
        }
        return secureRandom;
    }

    public SecureRandomBuilder provider(@Nonnull String provider) {
        this.provider = provider;
        return this;
    }
}

