/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.random.date;

import de.alpharogroup.date.CalculateDateExtensions;
import de.alpharogroup.random.RandomExtensions;
import java.security.SecureRandom;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;

public final class RandomDateExtensions {
    public static Date dateAfter(Date date) {
        return RandomDateExtensions.dateAfter(date, RandomExtensions.randomInt(10000));
    }

    public static Date dateAfter(Date date, int range) {
        return CalculateDateExtensions.addDays((Date)date, (int)RandomExtensions.randomInt(range));
    }

    public static Date dateBefore(Date date) {
        return RandomDateExtensions.dateBefore(date, 10000);
    }

    public static Date dateBefore(Date date, int range) {
        return CalculateDateExtensions.substractDaysFromDate((Date)date, (int)range);
    }

    public static Timestamp getTimestamp() {
        return RandomDateExtensions.getTimestamp(new Date());
    }

    public static Timestamp getTimestamp(Date date) {
        GregorianCalendar gregCal = new GregorianCalendar();
        gregCal.setTime(date);
        gregCal.set(11, 0);
        gregCal.set(12, 0);
        gregCal.set(13, 0);
        gregCal.set(14, 0);
        return new Timestamp(gregCal.getTime().getTime());
    }

    public static Date randomBirthday() {
        Date now = new Date(System.currentTimeMillis());
        Date past = RandomDateExtensions.dateBefore(now, 20000);
        Date recentlyPast = RandomDateExtensions.dateBefore(now, 3000);
        Date randomBirthday = RandomDateExtensions.randomBirthday(recentlyPast, past);
        return randomBirthday;
    }

    public static Date randomBirthday(Date from, Date till) {
        Date randomBirthday = RandomDateExtensions.randomDatebetween(from, till);
        return randomBirthday;
    }

    public static Date randomDate(Date from) {
        SecureRandom secrand = new SecureRandom();
        double randDouble = -secrand.nextDouble() * (double)from.getTime();
        double randomDouble = (double)from.getTime() - secrand.nextDouble();
        double result = randDouble / 99999.0 * (randomDouble / 99999.0);
        return new Date((long)result);
    }

    public static Date randomDatebetween(Date start, Date end) {
        SecureRandom secran = new SecureRandom();
        long randomLong = (long)((double)start.getTime() + secran.nextDouble() * (double)(end.getTime() - start.getTime()));
        return new Date(randomLong);
    }

    public static String randomDatebetween(long startDate, long endDate) {
        return RandomDateExtensions.randomDatebetween(startDate, endDate, "dd.MM.yyyy HH:mm:ss");
    }

    public static String randomDatebetween(long startDate, long endDate, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        long randomLongBetween = RandomExtensions.randomLongBetween(startDate, endDate);
        Date between = new Date(randomLongBetween);
        return sdf.format(between);
    }

    public static Date randomDateBetween(Date from, int startDays, int endDays) {
        return RandomDateExtensions.dateAfter(from, RandomExtensions.randomIntBetween(startDays, endDays));
    }

    private RandomDateExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

