/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.random.object;

import de.alpharogroup.random.RandomCharacters;
import de.alpharogroup.random.number.RandomPrimitivesExtensions;

public final class RandomStringFactory {
    private RandomStringFactory() {
    }

    public static String newRandomString() {
        return RandomStringFactory.newRandomString(RandomCharacters.lowcaseWithUppercaseAndNumbers.getCharacters(), RandomPrimitivesExtensions.randomIntBetween(3, 25));
    }

    public static String newRandomString(int length) {
        int maxLength = Math.min(length, 1024);
        StringBuilder sb = new StringBuilder(maxLength);
        for (int i = 0; i < maxLength; ++i) {
            sb.append(RandomPrimitivesExtensions.randomChar());
        }
        return sb.toString();
    }

    public static String newRandomString(int start, int end) {
        return RandomStringFactory.newRandomString(RandomPrimitivesExtensions.randomIntBetween(start, end));
    }

    public static String newRandomString(String chars, int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            sb.append(RandomPrimitivesExtensions.randomChar(chars));
        }
        return sb.toString();
    }

    public static String newRandomString(String[] array) {
        return array[RandomPrimitivesExtensions.randomInt(array.length)];
    }
}

