/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.random.number;

import de.alpharogroup.math.MathExtensions;
import de.alpharogroup.random.enums.RandomAlgorithm;
import de.alpharogroup.random.number.RandomPrimitivesExtensions;
import java.security.SecureRandom;
import java.util.Objects;
import java.util.Random;

public final class RandomPrimitivesFactory {
    public static boolean randomBoolean(SecureRandom secureRandom) {
        return RandomPrimitivesFactory.randomInt(2, RandomAlgorithm.SECURE_RANDOM, Objects.requireNonNull(secureRandom)) == 0;
    }

    public static byte randomByte(SecureRandom secureRandom) {
        return (byte)RandomPrimitivesFactory.randomInt(255, RandomAlgorithm.SECURE_RANDOM, Objects.requireNonNull(secureRandom));
    }

    public static byte[] randomByteArray(int length, SecureRandom secureRandom) {
        Objects.requireNonNull(secureRandom);
        byte[] randomByteArray = new byte[length];
        byte[] randomByteBox = new byte[1];
        for (int i = 0; i < length; ++i) {
            if (RandomPrimitivesFactory.randomBoolean(secureRandom)) {
                randomByteArray[i] = RandomPrimitivesFactory.randomByte(secureRandom);
                continue;
            }
            secureRandom.nextBytes(randomByteBox);
            randomByteArray[i] = randomByteBox[0];
        }
        return randomByteArray;
    }

    public static char randomChar(SecureRandom secureRandom) {
        Objects.requireNonNull(secureRandom);
        if (secureRandom.nextBoolean()) {
            return (char)(secureRandom.nextInt(26) + 65);
        }
        return (char)secureRandom.nextInt(10);
    }

    public static double randomDouble(double range, RandomAlgorithm algorithm, SecureRandom secureRandom) {
        Objects.requireNonNull(algorithm);
        Objects.requireNonNull(secureRandom);
        switch (algorithm) {
            case MATH_ABS: {
                return Math.abs(secureRandom.nextDouble()) % range;
            }
            case MATH_RANDOM: {
                return Math.random() * range;
            }
            case RANDOM: {
                double random = new Random(System.currentTimeMillis()).nextDouble() % range;
                return MathExtensions.isPositive((double)random) ? random : random * -1.0;
            }
        }
        return secureRandom.nextDouble() * range;
    }

    public static double randomDouble(double range, SecureRandom secureRandom) {
        return RandomPrimitivesFactory.randomDouble(range, RandomAlgorithm.SECURE_RANDOM, secureRandom);
    }

    public static double randomDouble(SecureRandom secureRandom) {
        return RandomPrimitivesExtensions.randomDouble(Objects.requireNonNull(secureRandom).nextDouble());
    }

    public static double randomDoubleBetween(double start, double end, SecureRandom secureRandom) {
        return start + RandomPrimitivesFactory.randomDouble(end - start, RandomAlgorithm.SECURE_RANDOM, Objects.requireNonNull(secureRandom));
    }

    public static float randomFloat(float range, RandomAlgorithm algorithm, SecureRandom secureRandom) {
        Objects.requireNonNull(algorithm);
        Objects.requireNonNull(secureRandom);
        switch (algorithm) {
            case MATH_ABS: {
                return (float)(Math.abs(secureRandom.nextDouble()) % (double)range);
            }
            case MATH_RANDOM: {
                return (float)(Math.random() * (double)range);
            }
            case RANDOM: {
                float random = (float)new Random(System.currentTimeMillis()).nextDouble() % range;
                return MathExtensions.isPositive((float)random) ? random : random * -1.0f;
            }
        }
        return (float)(secureRandom.nextDouble() * (double)range);
    }

    public static float randomFloat(float range, SecureRandom secureRandom) {
        return RandomPrimitivesFactory.randomFloat(range, RandomAlgorithm.SECURE_RANDOM, secureRandom);
    }

    public static float randomFloat(SecureRandom secureRandom) {
        return RandomPrimitivesExtensions.randomFloat(Objects.requireNonNull(secureRandom).nextFloat());
    }

    public static float randomFloatBetween(float start, float end, SecureRandom secureRandom) {
        return start + RandomPrimitivesFactory.randomFloat(end - start, RandomAlgorithm.SECURE_RANDOM, Objects.requireNonNull(secureRandom));
    }

    public static int randomInt(int range, RandomAlgorithm algorithm, SecureRandom secureRandom) {
        Objects.requireNonNull(algorithm);
        Objects.requireNonNull(secureRandom);
        switch (algorithm) {
            case MATH_ABS: {
                return Math.abs(secureRandom.nextInt()) % range;
            }
            case MATH_RANDOM: {
                return (int)(Math.random() * (double)range);
            }
            case RANDOM: {
                int random = new Random(System.currentTimeMillis()).nextInt() % range;
                return MathExtensions.isPositive((int)random) ? random : random * -1;
            }
        }
        return (int)(secureRandom.nextDouble() * (double)range);
    }

    public static int randomInt(int range, SecureRandom secureRandom) {
        return RandomPrimitivesFactory.randomInt(range, RandomAlgorithm.SECURE_RANDOM, secureRandom);
    }

    public static int randomInt(SecureRandom secureRandom) {
        return RandomPrimitivesExtensions.randomInt(Objects.requireNonNull(secureRandom).nextInt());
    }

    public static int randomIntBetween(int minVolume, int maxVolume, SecureRandom secureRandom) {
        return minVolume + RandomPrimitivesFactory.randomInt(maxVolume - minVolume, RandomAlgorithm.SECURE_RANDOM, Objects.requireNonNull(secureRandom));
    }

    public static long randomLong(long range, RandomAlgorithm algorithm, SecureRandom secureRandom) {
        Objects.requireNonNull(algorithm);
        Objects.requireNonNull(secureRandom);
        switch (algorithm) {
            case MATH_ABS: {
                return (long)(Math.abs(secureRandom.nextDouble()) % (double)range);
            }
            case MATH_RANDOM: {
                return (long)(Math.random() * (double)range);
            }
            case RANDOM: {
                long random = (long)new Random(System.currentTimeMillis()).nextDouble() % range;
                return MathExtensions.isPositive((long)random) ? random : random * -1L;
            }
        }
        return (long)(secureRandom.nextDouble() * (double)range);
    }

    public static long randomLong(long range, SecureRandom secureRandom) {
        return RandomPrimitivesFactory.randomLong(range, RandomAlgorithm.SECURE_RANDOM, secureRandom);
    }

    public static long randomLong(SecureRandom secureRandom) {
        return RandomPrimitivesExtensions.randomLong(Objects.requireNonNull(secureRandom).nextLong());
    }

    public static long randomLongBetween(long start, long end, SecureRandom secureRandom) {
        return start + RandomPrimitivesFactory.randomLong(end - start, RandomAlgorithm.SECURE_RANDOM, Objects.requireNonNull(secureRandom));
    }

    public static short randomShort(SecureRandom secureRandom) {
        Objects.requireNonNull(secureRandom);
        if (secureRandom.nextBoolean()) {
            return (short)(secureRandom.nextInt(65536) - 32768);
        }
        return (short)secureRandom.nextInt(32768);
    }

    private RandomPrimitivesFactory() {
    }
}

