/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.random.number;

import de.alpharogroup.random.DefaultSecureRandom;
import de.alpharogroup.random.SecureRandomFactory;
import de.alpharogroup.random.enums.RandomAlgorithm;
import de.alpharogroup.random.number.RandomNumberExtensions;
import de.alpharogroup.random.number.RandomPrimitivesFactory;
import java.util.Objects;

public final class RandomPrimitivesExtensions {
    private static String getRandomFloatString(int afterComma, int beforeComma) {
        return RandomNumberExtensions.getRandomNumericString(afterComma) + "." + RandomNumberExtensions.getRandomNumericString(beforeComma);
    }

    public static int getRandomIntBetween(int minVolume, int maxVolume) {
        return RandomPrimitivesFactory.randomIntBetween(minVolume, maxVolume, DefaultSecureRandom.get());
    }

    public static boolean randomBoolean() {
        return RandomPrimitivesExtensions.randomInt(2) == 0;
    }

    public static byte randomByte() {
        return (byte)RandomPrimitivesExtensions.randomInt(255);
    }

    public static byte[] randomByteArray(int length) {
        return RandomPrimitivesFactory.randomByteArray(length, DefaultSecureRandom.get());
    }

    public static char randomChar() {
        return RandomPrimitivesFactory.randomChar(DefaultSecureRandom.get());
    }

    public static char randomChar(String string) {
        return string.charAt(RandomPrimitivesExtensions.randomInt(string.length()));
    }

    public static double randomDouble() {
        return RandomPrimitivesExtensions.randomDouble(Double.MAX_VALUE);
    }

    public static double randomDouble(double range) {
        return RandomPrimitivesExtensions.randomDouble(range, RandomAlgorithm.SECURE_RANDOM);
    }

    public static double randomDouble(double range, RandomAlgorithm algorithm) {
        return RandomPrimitivesFactory.randomDouble(range, Objects.requireNonNull(algorithm), DefaultSecureRandom.get());
    }

    public static double randomDoubleBetween(double start, double end) {
        return RandomPrimitivesFactory.randomDoubleBetween(start, end, SecureRandomFactory.newSecureRandom());
    }

    public static float randomFloat() {
        return RandomPrimitivesFactory.randomFloat(DefaultSecureRandom.get());
    }

    public static float randomFloat(float range) {
        return RandomPrimitivesExtensions.randomFloat(range, RandomAlgorithm.SECURE_RANDOM);
    }

    public static float randomFloat(float range, RandomAlgorithm algorithm) {
        return RandomPrimitivesFactory.randomFloat(range, Objects.requireNonNull(algorithm), DefaultSecureRandom.get());
    }

    public static float randomFloat(int afterComma, int beforeComma) {
        return Float.parseFloat(RandomPrimitivesExtensions.getRandomFloatString(afterComma, beforeComma));
    }

    public static float randomFloatBetween(float start, float end) {
        return RandomPrimitivesFactory.randomFloatBetween(start, end, SecureRandomFactory.newSecureRandom());
    }

    public static int randomInt() {
        return RandomPrimitivesFactory.randomInt(DefaultSecureRandom.get());
    }

    public static int randomInt(int range) {
        return RandomPrimitivesExtensions.randomInt(range, RandomAlgorithm.SECURE_RANDOM);
    }

    public static int randomInt(int range, RandomAlgorithm algorithm) {
        return RandomPrimitivesFactory.randomInt(range, Objects.requireNonNull(algorithm), DefaultSecureRandom.get());
    }

    public static int randomIntBetween(int start, int end) {
        return RandomPrimitivesExtensions.randomIntBetween(start, end, true, false);
    }

    public static int randomIntBetween(int start, int end, boolean includeMin, boolean includeMax) {
        int randomIntBetween = start + RandomPrimitivesExtensions.randomInt(end - (start - 1));
        if (includeMin && !includeMax) {
            randomIntBetween = start + RandomPrimitivesExtensions.randomInt(end - start);
        }
        if (!includeMin && includeMax && randomIntBetween == start) {
            ++randomIntBetween;
        }
        if (!includeMin && !includeMax) {
            randomIntBetween = start + 1 + RandomPrimitivesExtensions.randomInt(end - (start + 1));
        }
        return randomIntBetween;
    }

    public static long randomLong() {
        return RandomPrimitivesFactory.randomLong(DefaultSecureRandom.get());
    }

    public static long randomLong(long range) {
        return RandomPrimitivesExtensions.randomLong(range, RandomAlgorithm.SECURE_RANDOM);
    }

    public static long randomLong(long range, RandomAlgorithm algorithm) {
        return RandomPrimitivesFactory.randomLong(range, Objects.requireNonNull(algorithm), DefaultSecureRandom.get());
    }

    public static long randomLongBetween(long start, long end) {
        return RandomPrimitivesFactory.randomLongBetween(start, end, SecureRandomFactory.newSecureRandom());
    }

    public static short randomShort() {
        return RandomPrimitivesFactory.randomShort(DefaultSecureRandom.get());
    }

    private RandomPrimitivesExtensions() {
    }
}

